/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.kafka;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.kafka.HonoTopic;
import org.eclipse.hono.client.kafka.KafkaProducerConfigProperties;
import org.eclipse.hono.client.kafka.KafkaProducerFactory;
import org.eclipse.hono.client.kafka.KafkaRecordHelper;
import org.eclipse.hono.client.kafka.producer.AbstractKafkaBasedMessageSender;

public class KafkaBasedCommandResponseSender
extends AbstractKafkaBasedMessageSender
implements CommandResponseSender {
    public KafkaBasedCommandResponseSender(KafkaProducerFactory<String, Buffer> producerFactory, KafkaProducerConfigProperties producerConfig, Tracer tracer) {
        super(producerFactory, "command_response", producerConfig, tracer);
    }

    public Future<Void> sendCommandResponse(CommandResponse response, SpanContext context) {
        Objects.requireNonNull(response);
        String topic = new HonoTopic(HonoTopic.Type.COMMAND_RESPONSE, response.getTenantId()).toString();
        Span span = this.startChildSpan("forward Command response", topic, response.getTenantId(), response.getDeviceId(), context);
        this.log.trace("publish command response [{}]", (Object)response);
        if (response.getMessagingType() != this.getMessagingType()) {
            span.log(String.format("using messaging type %s instead of type %s used for the original command", this.getMessagingType(), response.getMessagingType()));
        }
        return this.sendAndWaitForOutcome(topic, response.getTenantId(), response.getDeviceId(), response.getPayload(), this.getHeaders(response), span);
    }

    private List<KafkaHeader> getHeaders(CommandResponse response) {
        return List.of(KafkaRecordHelper.createKafkaHeader((String)"correlation-id", (Object)response.getCorrelationId()), KafkaRecordHelper.createKafkaHeader((String)"device_id", (Object)response.getDeviceId()), KafkaRecordHelper.createKafkaHeader((String)"status", (Object)response.getStatus()), KafkaRecordHelper.createKafkaHeader((String)"content-type", (Object)(Objects.nonNull(response.getContentType()) ? response.getContentType() : "application/octet-stream")));
    }
}

