/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.amqp.AbstractServiceClient;
import org.eclipse.hono.client.amqp.DownstreamAmqpMessageFactory;
import org.eclipse.hono.client.amqp.GenericSenderLink;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.command.CommandResponse;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.TenantObject;

public class ProtonBasedCommandResponseSender
extends AbstractServiceClient
implements CommandResponseSender {
    private final boolean jmsVendorPropsEnabled;

    public ProtonBasedCommandResponseSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory, boolean jmsVendorPropsEnabled) {
        super(connection, samplerFactory);
        this.jmsVendorPropsEnabled = jmsVendorPropsEnabled;
    }

    private Future<GenericSenderLink> createSender(String tenantId, String replyId) {
        return this.connection.executeOnContext(result -> GenericSenderLink.create((HonoConnection)this.connection, (String)"command_response", (String)tenantId, (String)replyId, (SendMessageSampler)this.samplerFactory.create("command_response"), onRemoteClose -> {}).onComplete((Handler)result));
    }

    private Message createDownstreamMessage(CommandResponse response, TenantObject tenant, RegistrationAssertion device) {
        ResourceIdentifier target = ResourceIdentifier.from((String)"command_response", (String)response.getTenantId(), (String)response.getReplyToId());
        Message msg = DownstreamAmqpMessageFactory.newMessage((ResourceIdentifier)target, (String)response.getContentType(), (Buffer)response.getPayload(), (TenantObject)tenant, (Map)tenant.getDefaults().getMap(), (Map)device.getDefaults(), (Map)response.getAdditionalProperties(), (boolean)this.jmsVendorPropsEnabled);
        msg.setAddress(target.toString());
        msg.setCorrelationId((Object)response.getCorrelationId());
        AmqpUtils.addStatus((Message)msg, (int)response.getStatus());
        AmqpUtils.addTenantId((Message)msg, (String)response.getTenantId());
        AmqpUtils.addDeviceId((Message)msg, (String)response.getDeviceId());
        return msg;
    }

    public Future<Void> sendCommandResponse(TenantObject tenant, RegistrationAssertion device, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(device);
        Objects.requireNonNull(response);
        Future<GenericSenderLink> sender = this.createSender(response.getTenantId(), response.getReplyToId());
        return sender.recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(s -> {
            Message msg = this.createDownstreamMessage(response, tenant, device);
            Span span = this.newChildSpan(context, "forward Command response");
            if (response.getMessagingType() != this.getMessagingType()) {
                span.log(String.format("using messaging type %s instead of type %s used for the original command", this.getMessagingType(), response.getMessagingType()));
            }
            return s.sendAndWaitForOutcome(msg, span);
        }).onSuccess(delivery -> ((GenericSenderLink)sender.result()).close()).mapEmpty();
    }
}

