/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Objects;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtonBasedLegacyCommandWrapper
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedLegacyCommandWrapper.class);
    private final org.eclipse.hono.client.Command command;

    public ProtonBasedLegacyCommandWrapper(org.eclipse.hono.client.Command command) {
        this.command = Objects.requireNonNull(command);
        if (Strings.isNullOrEmpty((Object)command.getTenant()) || Strings.isNullOrEmpty((Object)command.getOriginalDeviceId())) {
            LOG.warn("given command expected to have a valid tenant/device id: {}", (Object)command);
        }
    }

    public MessagingType getMessagingType() {
        return MessagingType.amqp;
    }

    public boolean isOneWay() {
        return this.command.isOneWay();
    }

    public boolean isValid() {
        return this.command.isValid();
    }

    public String getInvalidCommandReason() {
        return this.command.getInvalidCommandReason();
    }

    public String getTenant() {
        return this.command.getTenant();
    }

    public String getGatewayOrDeviceId() {
        return this.command.getDeviceId();
    }

    public boolean isTargetedAtGateway() {
        return this.command.isTargetedAtGateway();
    }

    public String getDeviceId() {
        return this.command.getOriginalDeviceId();
    }

    public String getGatewayId() {
        return this.isTargetedAtGateway() ? this.getGatewayOrDeviceId() : null;
    }

    public void setGatewayId(String gatewayId) {
        this.command.setGatewayId(gatewayId);
    }

    public String getName() {
        return this.command.getName();
    }

    public String getRequestId() {
        return this.command.getRequestId();
    }

    public Buffer getPayload() {
        return this.command.getPayload();
    }

    public int getPayloadSize() {
        return this.command.getPayloadSize();
    }

    public String getContentType() {
        return this.command.getContentType();
    }

    public String getReplyToId() {
        return this.command.getReplyToId();
    }

    public String getCorrelationId() {
        return this.command.getCorrelationId();
    }

    public String toString() {
        return this.command.toString();
    }

    public void logToSpan(Span span) {
        Objects.requireNonNull(span);
        if (this.command.isValid()) {
            TracingHelper.TAG_CORRELATION_ID.set(span, this.command.getCorrelationId());
            HashMap<String, String> items = new HashMap<String, String>(5);
            items.put("event", "received command message");
            items.put("to", this.command.getCommandMessage().getAddress());
            items.put("reply-to", this.command.getCommandMessage().getReplyTo());
            items.put("name", this.command.getName());
            items.put("content-type", this.command.getContentType());
            span.log(items);
        } else {
            TracingHelper.logError((Span)span, (String)("received invalid command message [" + this.command + "]"));
        }
    }
}

