/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command.amqp;

import io.opentracing.Span;
import io.vertx.core.Future;
import io.vertx.proton.ProtonHelper;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.NoConsumerException;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.client.amqp.SenderCachingServiceClient;
import org.eclipse.hono.client.command.Command;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.InternalCommandSender;
import org.eclipse.hono.client.command.amqp.ProtonBasedCommand;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonBasedInternalCommandSender
extends SenderCachingServiceClient
implements InternalCommandSender {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonBasedInternalCommandSender.class);

    public ProtonBasedInternalCommandSender(HonoConnection connection) {
        super(connection, SendMessageSampler.Factory.noop(), false);
    }

    public Future<Void> sendCommand(CommandContext commandContext, String adapterInstanceId) {
        Objects.requireNonNull(commandContext);
        return this.getOrCreateSenderLink(ProtonBasedInternalCommandSender.getTargetAddress(adapterInstanceId)).recover(thr -> Future.failedFuture((Throwable)StatusCodeMapper.toServerError((Throwable)thr))).compose(sender -> {
            Span span = this.newChildSpan(commandContext.getTracingContext(), "delegate Command request");
            Command command = commandContext.getCommand();
            Message message = this.adoptOrCreateMessage(command);
            TracingHelper.setDeviceTags((Span)span, (String)command.getTenant(), (String)command.getDeviceId());
            if (command.isTargetedAtGateway()) {
                MessageHelper.addProperty((Message)message, (String)"via", (Object)command.getGatewayId());
                TracingHelper.TAG_GATEWAY_ID.set(span, command.getGatewayId());
            }
            return sender.sendAndWaitForRawOutcome(message, span);
        }).map(delivery -> {
            DeliveryState remoteState = delivery.getRemoteState();
            LOG.trace("command [{}] sent to downstream peer; remote state of delivery: {}", (Object)commandContext.getCommand(), (Object)remoteState);
            if (Accepted.class.isInstance(remoteState)) {
                commandContext.accept();
            } else if (Rejected.class.isInstance(remoteState)) {
                Rejected rejected = (Rejected)remoteState;
                commandContext.reject((String)Optional.ofNullable(rejected.getError()).map(ErrorCondition::getDescription).orElse(null));
            } else if (Released.class.isInstance(remoteState)) {
                commandContext.release();
            } else if (Modified.class.isInstance(remoteState)) {
                Modified modified = (Modified)remoteState;
                commandContext.modify(modified.getDeliveryFailed().booleanValue(), modified.getUndeliverableHere().booleanValue());
            }
            return null;
        }).onFailure(thr -> {
            LOG.debug("failed to send command [{}] to downstream peer", (Object)commandContext.getCommand(), thr);
            if (thr instanceof NoConsumerException) {
                TracingHelper.logError((Span)commandContext.getTracingSpan(), (String)("no credit - target adapter instance '" + adapterInstanceId + "' may be offline in which case the device hasn't subscribed again yet"));
            }
            commandContext.release(thr);
        });
    }

    static String getTargetAddress(String adapterInstanceId) {
        return "command_internal/" + Objects.requireNonNull(adapterInstanceId);
    }

    private Message adoptOrCreateMessage(Command command) {
        Message msg;
        if (command instanceof ProtonBasedCommand) {
            msg = MessageHelper.getShallowCopy((Message)((ProtonBasedCommand)command).getMessage());
        } else {
            msg = ProtonHelper.message();
            byte[] payloadBytesOrNull = command.getPayload() != null ? command.getPayload().getBytes() : null;
            MessageHelper.setPayload((Message)msg, (String)command.getContentType(), (byte[])payloadBytesOrNull);
            msg.setAddress(this.getCommandMessageAddress(command));
            msg.setSubject(command.getName());
            if (command.getContentType() != null) {
                msg.setContentType(command.getContentType());
            }
        }
        if (command.getCorrelationId() != null) {
            msg.setCorrelationId((Object)command.getCorrelationId());
        }
        if (!command.isOneWay()) {
            msg.setReplyTo(this.getReplyToAddress(command));
        }
        return msg;
    }

    private String getCommandMessageAddress(Command command) {
        return String.format("%s/%s/%s", "command", command.getTenant(), command.getDeviceId());
    }

    private String getReplyToAddress(Command command) {
        return command.isOneWay() ? null : String.format("%s/%s/%s", "command_response", command.getTenant(), command.getReplyToId());
    }

    public String toString() {
        return ProtonBasedInternalCommandSender.class.getName() + " via AMQP 1.0 Messaging Network";
    }
}

