/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client;

import io.vertx.core.buffer.Buffer;
import java.time.Instant;
import java.util.Optional;
import org.eclipse.hono.application.client.Message;
import org.eclipse.hono.application.client.MessageContext;
import org.eclipse.hono.application.client.MessageProperties;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.TimeUntilDisconnectNotification;

public interface DownstreamMessage<T extends MessageContext>
extends Message<T> {
    public String getTenantId();

    public String getDeviceId();

    public MessageProperties getProperties();

    public String getContentType();

    public QoS getQos();

    public Buffer getPayload();

    public Instant getCreationTime();

    public Integer getTimeTillDisconnect();

    public String getCorrelationId();

    public Integer getStatus();

    default public boolean isSenderConnected() {
        return this.isSenderConnected(Instant.now());
    }

    default public boolean isSenderConnected(Instant now) {
        int ttd = Optional.ofNullable(this.getTimeTillDisconnect()).orElse(0);
        switch (ttd) {
            case -1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        return Optional.ofNullable(this.getCreationTime()).map(ct -> ct.plusSeconds(ttd)).map(now::isBefore).orElse(false);
    }

    default public Optional<TimeUntilDisconnectNotification> getTimeUntilDisconnectNotification() {
        Integer ttd = this.getTimeTillDisconnect();
        Instant creationTime = this.getCreationTime();
        if (ttd == null) {
            return Optional.empty();
        }
        if (ttd == 0 || TimeUntilDisconnectNotification.isDeviceCurrentlyConnected((Integer)ttd, creationTime != null ? Long.valueOf(creationTime.toEpochMilli()) : null)) {
            String tenantId = this.getTenantId();
            String deviceId = this.getDeviceId();
            if (tenantId != null && deviceId != null) {
                TimeUntilDisconnectNotification notification = new TimeUntilDisconnectNotification(tenantId, deviceId, ttd, creationTime);
                return Optional.of(notification);
            }
        }
        return Optional.empty();
    }
}

