/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.amqp;

import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonDelivery;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.MessageProperties;
import org.eclipse.hono.application.client.amqp.AmqpMessageContext;
import org.eclipse.hono.client.amqp.connection.AmqpUtils;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;

public final class ProtonBasedDownstreamMessage
implements DownstreamMessage<AmqpMessageContext> {
    private final Message message;
    private final AmqpMessageContext context;
    private final MessageProperties properties;

    private ProtonBasedDownstreamMessage(final Message msg, ProtonDelivery delivery) {
        Objects.requireNonNull(msg);
        Objects.requireNonNull(delivery);
        this.message = msg;
        this.context = new AmqpMessageContext(delivery, msg);
        final Map props = Collections.unmodifiableMap(Optional.ofNullable(msg.getApplicationProperties()).map(ApplicationProperties::getValue).orElse(Map.of()));
        this.properties = new MessageProperties(){

            public Map<String, Object> getPropertiesMap() {
                return props;
            }

            public <T> T getProperty(String name, Class<T> type) {
                return (T)AmqpUtils.getApplicationProperty((Message)msg, (String)name, type);
            }
        };
    }

    public static ProtonBasedDownstreamMessage from(Message msg, ProtonDelivery delivery) {
        return new ProtonBasedDownstreamMessage(msg, delivery);
    }

    public String getTenantId() {
        return Optional.ofNullable(this.message.getAddress()).map(address -> ResourceIdentifier.isValid((String)address) ? address : null).map(ResourceIdentifier::fromString).map(ResourceIdentifier::getTenantId).orElseThrow(() -> new IllegalStateException("message has no proper address"));
    }

    public String getDeviceId() {
        return AmqpUtils.getDeviceId((Message)this.message);
    }

    public MessageProperties getProperties() {
        return this.properties;
    }

    public String getContentType() {
        return this.message.getContentType();
    }

    public AmqpMessageContext getMessageContext() {
        return this.context;
    }

    public QoS getQos() {
        return Optional.ofNullable((Integer)AmqpUtils.getApplicationProperty((Message)this.message, (String)"qos", Integer.class)).map(QoS::from).orElse(QoS.AT_MOST_ONCE);
    }

    public Buffer getPayload() {
        return AmqpUtils.getPayload((Message)this.message);
    }

    public Instant getCreationTime() {
        return this.message.getCreationTime() == 0L ? null : Instant.ofEpochMilli(this.message.getCreationTime());
    }

    public Duration getTimeToLive() {
        return this.message.getTtl() == 0L ? null : Duration.ofMillis(this.message.getTtl());
    }

    public Integer getTimeTillDisconnect() {
        return AmqpUtils.getTimeUntilDisconnect((Message)this.message);
    }

    public String getCorrelationId() {
        return Optional.ofNullable(this.message.getCorrelationId()).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    public Integer getStatus() {
        return AmqpUtils.getStatus((Message)this.message);
    }
}

