/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.client.amqp.AbstractRequestResponseServiceClient;
import org.eclipse.hono.client.amqp.RequestResponseClient;
import org.eclipse.hono.client.impl.CachingClientFactory;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.AddressHelper;
import org.eclipse.hono.util.BufferResult;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RequestResponseResult;

final class ProtonBasedRequestResponseCommandClient
extends AbstractRequestResponseServiceClient<Buffer, BufferResult> {
    private int messageCounter;

    protected ProtonBasedRequestResponseCommandClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        super(connection, samplerFactory, new CachingClientFactory(connection.getVertx(), RequestResponseClient::isOpen), null);
    }

    protected String getKey(String tenantId) {
        return String.format("%s-%s", "command", tenantId);
    }

    protected BufferResult getResult(int status, String contentType, Buffer payload, CacheDirective cacheDirective, ApplicationProperties applicationProperties) {
        return BufferResult.from((int)status, (String)contentType, (Buffer)payload, (ApplicationProperties)applicationProperties);
    }

    public Future<BufferResult> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String replyId, Map<String, Object> properties, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        Span currentSpan = this.newChildSpan(context, "send command and receive response");
        return this.getOrCreateClient(tenantId, replyId).compose(client -> {
            String messageTargetAddress = AddressHelper.getTargetAddress((String)"command", (String)tenantId, (String)deviceId, (ClientConfigProperties)this.connection.getConfig());
            return client.createAndSendRequest(command, messageTargetAddress, properties, data, contentType, arg_0 -> ((ProtonBasedRequestResponseCommandClient)this).getRequestResponseResult(arg_0), currentSpan);
        }).recover(error -> {
            Tags.HTTP_STATUS.set(currentSpan, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)error)));
            TracingHelper.logError((Span)currentSpan, (Throwable)error);
            return Future.failedFuture((Throwable)error);
        }).map(bufferResult -> {
            this.setTagsForResult(currentSpan, (RequestResponseResult)bufferResult);
            if (bufferResult != null && bufferResult.isError()) {
                throw StatusCodeMapper.from((RequestResponseResult)bufferResult);
            }
            return bufferResult;
        }).onComplete(r -> currentSpan.finish());
    }

    private Future<RequestResponseClient<BufferResult>> getOrCreateClient(String tenantId, String replyId) {
        return this.connection.isConnected(this.getDefaultConnectionCheckTimeout()).compose(v -> this.connection.executeOnContext(result -> this.clientFactory.getOrCreateClient(this.getKey(tenantId), () -> RequestResponseClient.forEndpoint((HonoConnection)this.connection, (String)"command", (String)"command_response", (String)tenantId, (String)Optional.ofNullable(replyId).orElse(UUID.randomUUID().toString()), this::createMessageId, (SendMessageSampler)this.samplerFactory.create("command"), arg_0 -> ((ProtonBasedRequestResponseCommandClient)this).removeClient(arg_0), arg_0 -> ((ProtonBasedRequestResponseCommandClient)this).removeClient(arg_0)), (Handler)result)));
    }

    private String createMessageId() {
        return Long.toString(++this.messageCounter, 36);
    }
}

