/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp.connection;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonSession;
import io.vertx.proton.impl.ProtonDeliveryImpl;
import java.util.Objects;
import org.eclipse.hono.util.Futures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HonoProtonHelper {
    public static final long DEFAULT_FREE_LINK_AFTER_CLOSE_INTERVAL_MILLIS = 3000L;
    private static final Logger LOG = LoggerFactory.getLogger(HonoProtonHelper.class);

    private HonoProtonHelper() {
    }

    public static <T extends ProtonLink<T>> Handler<AsyncResult<T>> setDetachHandler(ProtonLink<T> link, Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(handler);
        Handler wrappedHandler = remoteDetach -> {
            try {
                handler.handle(remoteDetach);
            }
            catch (Exception ex) {
                LOG.warn("error running detachHandler", (Throwable)ex);
            }
            link.free();
        };
        link.detachHandler(wrappedHandler);
        return wrappedHandler;
    }

    public static <T extends ProtonLink<T>> Handler<AsyncResult<T>> setCloseHandler(ProtonLink<T> link, Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(link);
        Objects.requireNonNull(handler);
        Handler wrappedHandler = remoteClose -> {
            try {
                handler.handle(remoteClose);
            }
            catch (Exception ex) {
                LOG.warn("error running closeHandler", (Throwable)ex);
            }
            link.free();
        };
        link.closeHandler(wrappedHandler);
        return wrappedHandler;
    }

    public static <T extends ProtonLink<T>> void setDefaultCloseHandler(ProtonLink<T> link) {
        link.closeHandler(remoteClose -> {
            if (link.isOpen()) {
                link.close();
            }
            link.free();
        });
    }

    public static void setDefaultCloseHandler(ProtonSession session) {
        session.closeHandler(remoteClose -> {
            session.close();
            session.free();
        });
    }

    public static boolean isLinkEstablished(ProtonLink<?> link) {
        if (link instanceof ProtonSender) {
            return link.getRemoteTarget() != null;
        }
        if (link instanceof ProtonReceiver) {
            return link.getRemoteSource() != null && link.getRemoteSource().getAddress() != null;
        }
        return false;
    }

    public static boolean isLinkOpenAndConnected(ProtonLink<?> link) {
        if (link != null && link.isOpen()) {
            if (link.getSession() != null && link.getSession().getConnection() != null && !link.getSession().getConnection().isDisconnected()) {
                return true;
            }
            LOG.debug("{} link [source: {}, target: {}] is locally open but underlying transport is disconnected", new Object[]{link instanceof ProtonSender ? "sender" : "receiver", HonoProtonHelper.getRemoteOrLocalSourceAddress(link), HonoProtonHelper.getRemoteOrLocalTargetAddress(link)});
        }
        return false;
    }

    private static String getRemoteOrLocalSourceAddress(ProtonLink<?> link) {
        if (link != null && link.getRemoteSource() != null) {
            return link.getRemoteSource().getAddress();
        }
        return link != null && link.getSource() != null ? link.getSource().getAddress() : null;
    }

    private static String getRemoteOrLocalTargetAddress(ProtonLink<?> link) {
        if (link != null && link.getRemoteTarget() != null) {
            return link.getRemoteTarget().getAddress();
        }
        return link != null && link.getTarget() != null ? link.getTarget().getAddress() : null;
    }

    public static void closeAndFree(Context context, ProtonLink<?> link, Handler<Void> closeHandler) {
        HonoProtonHelper.closeAndFree(context, link, 3000L, closeHandler);
    }

    public static void closeAndFree(Context context, ProtonLink<?> link, long detachTimeOut, Handler<Void> closeHandler) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(closeHandler);
        if (detachTimeOut < 0L) {
            throw new IllegalArgumentException("detach time-out must be > 0");
        }
        Futures.executeOnContextWithSameRoot((Context)context, result -> {
            if (link == null) {
                closeHandler.handle(null);
            } else if (HonoProtonHelper.isLinkOpenAndConnected(link)) {
                long timerId = context.owner().setTimer(detachTimeOut, tid -> result.tryComplete());
                link.closeHandler(remoteDetach -> {
                    context.owner().cancelTimer(timerId);
                    result.tryComplete();
                });
                link.close();
            } else {
                result.complete();
            }
        }).onComplete(closeAttempt -> {
            closeHandler.handle(null);
            link.free();
        });
    }

    public static Future<Void> closeConnection(ProtonConnection connectionToClose, int timeoutMillis, Context vertxContext) {
        Objects.requireNonNull(connectionToClose);
        Objects.requireNonNull(vertxContext);
        int timeout = Math.max(timeoutMillis, 200);
        return Futures.executeOnContextWithSameRoot((Context)vertxContext, r -> {
            connectionToClose.disconnectHandler(null);
            Handler closeHandler = remoteClose -> {
                connectionToClose.disconnect();
                r.handle(remoteClose);
            };
            long timerId = vertxContext.owner().setTimer((long)timeout, tid -> {
                LOG.debug("did not receive remote peer's close frame after {}ms", (Object)timeout);
                closeHandler.handle((Object)Future.succeededFuture((Object)connectionToClose));
            });
            connectionToClose.closeHandler(remoteClose -> {
                if (vertxContext.owner().cancelTimer(timerId)) {
                    closeHandler.handle(remoteClose);
                }
            });
            connectionToClose.close();
        }).mapEmpty();
    }

    public static void onReceivedMessageDeliveryUpdatedFromRemote(ProtonDelivery delivery, Handler<ProtonDelivery> handler) {
        if (delivery instanceof ProtonDeliveryImpl) {
            ((ProtonDeliveryImpl)delivery).handler(handler);
        }
    }
}

