/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.proton.ProtonClient;
import io.vertx.proton.ProtonClientOptions;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonSender;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.cli.AbstractCliClient;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"amqp-adapter-cli"})
public class AmqpSend
extends AbstractCliClient {
    private ProtonConnection adapterConnection;
    @Value(value="${message.address}")
    protected String messageAddress;
    @Value(value="${amqp.host}")
    protected String amqpHost;
    @Value(value="${amqp.port}")
    protected int amqpPort;
    @Value(value="${username}")
    protected String username;
    @Value(value="${password}")
    protected String password;
    @Value(value="${payload}")
    protected String payload;

    @PostConstruct
    void start() {
        Message message = ProtonHelper.message((String)this.payload);
        message.setAddress(this.messageAddress);
        CountDownLatch sent = new CountDownLatch(1);
        this.connectToAdapter().setHandler(result -> {
            PrintWriter pw = new PrintWriter(System.out);
            if (result.succeeded()) {
                ProtonSender sender = this.adapterConnection.createSender(null);
                ((ProtonSender)sender.openHandler(remoteAttach -> {
                    if (remoteAttach.succeeded()) {
                        sender.send(message, delivery -> {
                            pw.println("\n" + delivery.getRemoteState() + "\n");
                            pw.flush();
                            sender.close();
                            if (this.adapterConnection != null) {
                                this.adapterConnection.close();
                            }
                            sent.countDown();
                        });
                    }
                })).open();
            } else {
                pw.println(result.cause());
                pw.flush();
            }
        });
        try {
            sent.await();
            System.exit(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Future<Void> connectToAdapter() {
        Future result = Future.future();
        ProtonClientOptions options = new ProtonClientOptions();
        ProtonClient client = ProtonClient.create((Vertx)this.vertx);
        if (!Strings.isNullOrEmpty((Object)this.username) && !Strings.isNullOrEmpty((Object)this.password)) {
            options.addEnabledSaslMechanism("PLAIN");
            client.connect(options, this.amqpHost, this.amqpPort, this.username, this.password, conAttempt -> {
                if (conAttempt.failed()) {
                    result.fail(conAttempt.cause());
                } else {
                    this.adapterConnection = (ProtonConnection)conAttempt.result();
                    this.adapterConnection.openHandler(remoteOpen -> {
                        if (remoteOpen.succeeded()) {
                            result.complete();
                        }
                    }).open();
                }
            });
        } else {
            client.connect(this.amqpHost, this.amqpPort, conAttempt -> {
                if (conAttempt.failed()) {
                    result.fail(conAttempt.cause());
                } else {
                    this.adapterConnection = (ProtonConnection)conAttempt.result();
                    this.adapterConnection.openHandler(remoteOpen -> {
                        if (remoteOpen.succeeded()) {
                            result.complete();
                        }
                    }).open();
                }
            });
        }
        return result;
    }
}

