/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.eclipse.hono.cli.AbstractClient;
import org.eclipse.hono.client.CommandClient;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.util.BufferResult;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"command"})
public class Commander
extends AbstractClient {
    private final Scanner scanner = new Scanner(System.in);
    @Value(value="${command.timeoutInSeconds}")
    protected int requestTimeoutInSecs;
    private WorkerExecutor workerExecutor;

    @PostConstruct
    void start() {
        this.workerExecutor = this.vertx.createSharedWorkerExecutor("user-input-pool", 3, TimeUnit.HOURS.toNanos(1L));
        this.startCommandClient((Future<HonoClient>)this.client.connect(x -> this.onDisconnect()));
    }

    private void startCommandClient(Future<HonoClient> clientFuture) {
        clientFuture.setHandler(this::handleClientConnectionStatus).compose(x -> this.getCommandFromUser()).compose(this::processCommand).setHandler(x -> this.startCommandClient(clientFuture));
    }

    private Future<Void> processCommand(Command command) {
        this.LOG.info("Command sent to device... [Command request will timeout in {} seconds]", (Object)this.requestTimeoutInSecs);
        return this.client.getOrCreateCommandClient(this.tenantId, this.deviceId).map(this::setRequestTimeOut).compose(commandClient -> commandClient.sendCommand(command.getCommand(), Buffer.buffer((String)command.getPayload())).map(this::printResponse).map(x -> this.closeCommandClient((CommandClient)commandClient)).otherwise(error -> {
            this.LOG.error("Error: {}", (Object)error.getMessage());
            return this.closeCommandClient((CommandClient)commandClient);
        }));
    }

    private CommandClient setRequestTimeOut(CommandClient commandClient) {
        commandClient.setRequestTimeout(TimeUnit.SECONDS.toMillis(this.requestTimeoutInSecs));
        return commandClient;
    }

    private Void closeCommandClient(CommandClient commandClient) {
        this.LOG.trace("Close command client to device [{}:{}]", (Object)this.tenantId, (Object)this.deviceId);
        commandClient.close(closeHandler -> {});
        return null;
    }

    private Void printResponse(BufferResult result) {
        this.LOG.info("Received Command response : {}", (Object)((Buffer)Optional.ofNullable(result.getPayload()).orElse(Buffer.buffer())).toString());
        return null;
    }

    private Future<Command> getCommandFromUser() {
        Future commandFuture = Future.future();
        this.workerExecutor.executeBlocking(userInputFuture -> {
            System.out.print(String.format(">>>>>>>>> Enter command for device [%s:%s] <then press Enter, hit ctrl-c to exit >: ", this.tenantId, this.deviceId));
            String honoCmd = this.scanner.nextLine();
            System.out.print(String.format(">>>>>>>>> Enter command payload for device [%s:%s] <then press Enter, hit ctrl-c to exit>: ", this.tenantId, this.deviceId));
            String honoPayload = this.scanner.nextLine();
            userInputFuture.complete((Object)new Command(honoCmd, honoPayload));
        }, result -> {
            if (result.succeeded()) {
                commandFuture.complete((Object)((Command)result.result()));
            } else {
                commandFuture.fail(result.cause());
            }
        });
        return commandFuture;
    }

    private void onDisconnect() {
        this.LOG.info("Connecting client...");
        this.vertx.setTimer((long)this.connectionRetryInterval, reconnect -> {
            this.LOG.info("attempting to re-connect to Hono ...");
            this.client.connect(con -> this.onDisconnect());
        });
    }

    private void handleClientConnectionStatus(AsyncResult<HonoClient> result) {
        if (result.failed()) {
            this.workerExecutor.close();
            this.vertx.close();
            this.LOG.error("Error: {}", (Object)result.cause().getMessage());
            throw new RuntimeException("Error connecting hono client", result.cause());
        }
    }

    private class Command {
        private final String command;
        private final String payload;

        Command(String command, String payload) {
            this.command = command;
            this.payload = payload;
        }

        private String getCommand() {
            return this.command;
        }

        private String getPayload() {
            return this.payload;
        }
    }
}

