/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.mqtt;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.mqtt.MqttAuth;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.mqtt.MqttConnectContext;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.ExternalJwtAuthTokenValidator;

public class JwtAuthHandler
extends ExecutionContextAuthHandler<MqttConnectContext> {
    static final String REQUIRED_AUD = "hono-adapter";
    private final ExternalJwtAuthTokenValidator authTokenValidator;

    public JwtAuthHandler(DeviceCredentialsAuthProvider<?> authProvider) {
        this(authProvider, null, new ExternalJwtAuthTokenValidator());
    }

    protected JwtAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, PreCredentialsValidationHandler<MqttConnectContext> preCredentialsValidationHandler, ExternalJwtAuthTokenValidator authTokenValidator) {
        super(authProvider, preCredentialsValidationHandler);
        this.authTokenValidator = authTokenValidator;
    }

    public Future<JsonObject> parseCredentials(MqttConnectContext context) {
        Objects.requireNonNull(context);
        if (context.deviceEndpoint() == null) {
            throw new IllegalArgumentException("no device endpoint");
        }
        Promise result = Promise.promise();
        MqttAuth auth = context.deviceEndpoint().auth();
        if (auth == null || !this.passwordMatchesJwtSyntax(auth.getPassword())) {
            result.fail((Throwable)new ClientErrorException(401, "device credentials in CONNECT packet are empty or malformed"));
        } else {
            Map<String, String> map = this.getTenantIdAndAuthIdFromClientIdentifier(context.deviceEndpoint().clientIdentifier());
            boolean failed = false;
            if (map == null) {
                map = this.getTenantIdAuthIdAndAudienceFromJwtClaims(auth.getPassword());
                if (map == null) {
                    failed = true;
                    result.fail((Throwable)new ClientErrorException(401, "Could not get tenant identifier and authentication identifier. They must be either provided in the client identifier in CONNECT packet or in the 'iss' and 'sub'claims of the JWT."));
                }
                if (!failed && !REQUIRED_AUD.equalsIgnoreCase(map.get("aud"))) {
                    failed = true;
                    result.fail((Throwable)new ClientErrorException(401, String.format("JWT did not specify the correct audience (aud claim). In case the tenant identifier and authentication identifier are provided inside the claims of the JWT, it also has to provide \"%s\" within the aud claim.", REQUIRED_AUD)));
                }
            }
            if (!failed) {
                JsonObject credentialsJSON = new JsonObject().put("tenant-id", (Object)map.get("tenant-id")).put("auth-id", (Object)map.get("auth-id")).put("password", (Object)auth.getPassword());
                result.complete((Object)credentialsJSON);
            }
        }
        return result.future();
    }

    private boolean passwordMatchesJwtSyntax(String password) {
        return password != null && !password.trim().isEmpty() && password.split("\\.").length == 3;
    }

    private Map<String, String> getTenantIdAndAuthIdFromClientIdentifier(String clientId) {
        String[] clientIdSplit = clientId.split("/");
        int splitLength = clientIdSplit.length;
        if (splitLength < 3) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("tenant-id", clientIdSplit[splitLength - 3]);
        result.put("auth-id", clientIdSplit[splitLength - 1]);
        return result;
    }

    private Map<String, String> getTenantIdAuthIdAndAudienceFromJwtClaims(String jwt) {
        try {
            JsonObject claims = this.authTokenValidator.getJwtClaims(jwt);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("tenant-id", claims.getString("iss"));
            result.put("auth-id", claims.getString("sub"));
            result.put("aud", claims.getString("aud"));
            return result;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

