/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class ObjeniousProvider
extends JsonBasedLoraProvider {
    private static final String FIELD_DEVICE_ID = "deveui";
    private static final String FIELD_FRAME_COUNT = "count";
    private static final String FIELD_LATITUDE = "lat";
    private static final String FIELD_LONGITUDE = "lng";
    private static final String FIELD_PAYLOAD = "payload_cleartext";
    private static final String FIELD_PORT = "port";
    private static final String FIELD_RSSI = "rssi";
    private static final String FIELD_SNR = "snr";
    private static final String FIELD_SPREADING_FACTOR = "sf";
    private static final String FIELD_TYPE = "type";
    private static final String OBJECT_DEVICE_PROPERTIES = "device_properties";
    private static final String OBJECT_PROTOCOL_DATA = "protocol_data";

    @Override
    public String getProviderName() {
        return "objenious";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/objenious");
    }

    @Override
    protected byte[] getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, OBJECT_DEVICE_PROPERTIES, JsonObject.class).map(props -> props.getValue(FIELD_DEVICE_ID)).filter(String.class::isInstance).map(String.class::cast).map(LoraUtils::convertFromHexToBytes).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain String valued device ID property"));
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_PAYLOAD, String.class).map(s -> Buffer.buffer((byte[])BaseEncoding.base16().decode((CharSequence)s.toUpperCase()))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain HEX encoded payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, FIELD_TYPE, String.class).map(type -> {
            switch (type) {
                case "join": {
                    return LoraMessageType.JOIN;
                }
                case "uplink": {
                    return LoraMessageType.UPLINK;
                }
                case "downlink": {
                    return LoraMessageType.DOWNLINK;
                }
            }
            return LoraMessageType.UNKNOWN;
        }).orElse(LoraMessageType.UNKNOWN);
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(loraMessage, FIELD_FRAME_COUNT, Integer.class).ifPresent(data::setFrameCount);
        Optional.ofNullable(LoraUtils.newLocation(LoraUtils.getChildObject(loraMessage, FIELD_LONGITUDE, Double.class), LoraUtils.getChildObject(loraMessage, FIELD_LATITUDE, Double.class), Optional.empty())).ifPresent(data::setLocation);
        LoraUtils.getChildObject(loraMessage, OBJECT_PROTOCOL_DATA, JsonObject.class).map(prot -> {
            LoraUtils.getChildObject(prot, FIELD_PORT, Integer.class).ifPresent(data::setFunctionPort);
            LoraUtils.getChildObject(prot, FIELD_SPREADING_FACTOR, Integer.class).ifPresent(data::setSpreadingFactor);
            GatewayInfo gwInfo = new GatewayInfo();
            LoraUtils.getChildObject(prot, FIELD_RSSI, Integer.class).ifPresent(gwInfo::setRssi);
            LoraUtils.getChildObject(prot, FIELD_SNR, Double.class).ifPresent(gwInfo::setSnr);
            return gwInfo;
        }).ifPresent(data::addGatewayInfo);
        return data;
    }
}

