/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.lora.Location;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;

public class LoraUtils {
    private LoraUtils() {
    }

    public static <T> Optional<T> getChildObject(JsonObject parent, String propertyName, Class<T> expectedType) {
        return Optional.ofNullable(parent.getValue(propertyName)).map(obj -> {
            if (Number.class.isAssignableFrom(expectedType) && obj instanceof Number) {
                Number number = (Number)obj;
                if (Double.class.equals((Object)expectedType)) {
                    return number.doubleValue();
                }
                if (Integer.class.equals((Object)expectedType)) {
                    return number.intValue();
                }
                if (Long.class.equals((Object)expectedType)) {
                    return number.longValue();
                }
                if (Float.class.equals((Object)expectedType)) {
                    return Float.valueOf(number.floatValue());
                }
                return number;
            }
            return obj;
        }).filter(expectedType::isInstance).map(expectedType::cast);
    }

    public static Location newLocationFromString(Optional<String> longitude, Optional<String> latitude, Optional<String> altitude) {
        Objects.requireNonNull(longitude);
        Objects.requireNonNull(latitude);
        Objects.requireNonNull(altitude);
        if (longitude.isEmpty() || latitude.isEmpty()) {
            return null;
        }
        try {
            Double lon = Double.valueOf(longitude.get());
            Double lat = Double.valueOf(latitude.get());
            Double alt = altitude.map(Double::valueOf).orElse(null);
            return new Location(lon, lat, alt);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Location newLocation(Optional<Double> longitude, Optional<Double> latitude, Optional<Double> altitude) {
        Objects.requireNonNull(longitude);
        Objects.requireNonNull(latitude);
        Objects.requireNonNull(altitude);
        if (longitude.isEmpty() || latitude.isEmpty()) {
            return null;
        }
        return new Location(longitude.get(), latitude.get(), altitude.orElse(null));
    }

    public static String convertFromBase64ToHex(String base64) {
        Objects.requireNonNull(base64);
        try {
            return LoraUtils.convertToHexString(Base64.getDecoder().decode(base64));
        }
        catch (IllegalArgumentException e) {
            throw new LoraProviderMalformedPayloadException("cannot decode Base64 data", e);
        }
    }

    public static byte[] convertFromBase64ToBytes(String base64) {
        Objects.requireNonNull(base64);
        try {
            return Base64.getDecoder().decode(base64);
        }
        catch (IllegalArgumentException e) {
            throw new LoraProviderMalformedPayloadException("cannot decode Base64 data", e);
        }
    }

    public static String convertToHexString(byte[] data) {
        Objects.requireNonNull(data);
        return BaseEncoding.base16().encode(data);
    }

    public static byte[] convertFromHexToBytes(String hex) {
        Objects.requireNonNull(hex);
        try {
            return BaseEncoding.base16().decode((CharSequence)hex.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new LoraProviderMalformedPayloadException("cannot decode hex data", e);
        }
    }
}

