/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.Set;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.ActilityBaseProvider;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class ActilityWirelessProvider
extends ActilityBaseProvider {
    private static final String FIELD_ACTILITY_ADR = "ADRbit";

    @Override
    public String getProviderName() {
        return "actilityWireless";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/actility", "/actilityWireless");
    }

    @Override
    protected LoraMetaData extractMetaData(JsonObject rootObject) {
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(rootObject, "SpFact", String.class).ifPresent(s -> data.setSpreadingFactor(Integer.valueOf(s)));
        LoraUtils.getChildObject(rootObject, "FPort", String.class).ifPresent(s -> data.setFunctionPort(Integer.valueOf(s)));
        LoraUtils.getChildObject(rootObject, "FCntUp", String.class).ifPresent(s -> data.setFrameCount(Integer.valueOf(s)));
        LoraUtils.getChildObject(rootObject, FIELD_ACTILITY_ADR, String.class).ifPresent(s -> data.setAdaptiveDataRateEnabled(s.equals("1") ? Boolean.TRUE : Boolean.FALSE));
        LoraUtils.getChildObject(rootObject, "Channel", String.class).map(this::getFrequency).ifPresent(data::setFrequency);
        Optional.ofNullable(LoraUtils.newLocationFromString(LoraUtils.getChildObject(rootObject, "DevLON", String.class), LoraUtils.getChildObject(rootObject, "DevLAT", String.class), LoraUtils.getChildObject(rootObject, "DevAlt", String.class))).ifPresent(data::setLocation);
        LoraUtils.getChildObject(rootObject, "Lrrs", JsonObject.class).map(lrrs -> lrrs.getValue("Lrr")).filter(JsonArray.class::isInstance).map(JsonArray.class::cast).ifPresent(lrrList -> {
            Optional<String> gwId = LoraUtils.getChildObject(rootObject, "Lrrid", String.class);
            lrrList.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(this::extractGatewayInfo).forEach(gateway -> {
                Optional.ofNullable(gateway.getGatewayId()).ifPresent(s -> gwId.ifPresent(id -> {
                    if (id.equals(s)) {
                        Optional.ofNullable(LoraUtils.newLocationFromString(LoraUtils.getChildObject(rootObject, "LrrLON", String.class), LoraUtils.getChildObject(rootObject, "LrrLAT", String.class), Optional.empty())).ifPresent(gateway::setLocation);
                    }
                }));
                data.addGatewayInfo((GatewayInfo)gateway);
            });
        });
        return data;
    }

    private GatewayInfo extractGatewayInfo(JsonObject lrr) {
        GatewayInfo gateway = new GatewayInfo();
        LoraUtils.getChildObject(lrr, "Lrrid", String.class).ifPresent(gateway::setGatewayId);
        LoraUtils.getChildObject(lrr, "LrrRSSI", String.class).ifPresent(s -> gateway.setRssi(Double.valueOf(s).intValue()));
        LoraUtils.getChildObject(lrr, "LrrSNR", String.class).ifPresent(s -> gateway.setSnr(Double.valueOf(s)));
        return gateway;
    }
}

