/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.Set;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.ActilityBaseProvider;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;

@ApplicationScoped
public class ActilityEnterpriseProvider
extends ActilityBaseProvider {
    @Override
    public String getProviderName() {
        return "actilityEnterprise";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/actilityEnterprise");
    }

    @Override
    protected LoraMetaData extractMetaData(JsonObject rootObject) {
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(rootObject, "SpFact", Integer.class).ifPresent(i -> data.setSpreadingFactor((Integer)i));
        LoraUtils.getChildObject(rootObject, "FPort", Integer.class).ifPresent(i -> data.setFunctionPort((Integer)i));
        LoraUtils.getChildObject(rootObject, "FCntUp", Integer.class).ifPresent(i -> data.setFrameCount((Integer)i));
        LoraUtils.getChildObject(rootObject, "Channel", String.class).map(this::getFrequency).ifPresent(data::setFrequency);
        Optional.ofNullable(LoraUtils.newLocation(LoraUtils.getChildObject(rootObject, "DevLON", Double.class), LoraUtils.getChildObject(rootObject, "DevLAT", Double.class), LoraUtils.getChildObject(rootObject, "DevAlt", Double.class))).ifPresent(data::setLocation);
        LoraUtils.getChildObject(rootObject, "Lrrs", JsonObject.class).map(lrrs -> lrrs.getValue("Lrr")).filter(JsonArray.class::isInstance).map(JsonArray.class::cast).ifPresent(lrrList -> {
            Optional<String> gwId = LoraUtils.getChildObject(rootObject, "Lrrid", String.class);
            lrrList.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(this::extractGatewayInfo).forEach(gateway -> {
                Optional.ofNullable(gateway.getGatewayId()).ifPresent(s -> gwId.ifPresent(id -> {
                    if (id.equals(s)) {
                        Optional.ofNullable(LoraUtils.newLocation(LoraUtils.getChildObject(rootObject, "LrrLON", Double.class), LoraUtils.getChildObject(rootObject, "LrrLAT", Double.class), Optional.empty())).ifPresent(gateway::setLocation);
                    }
                }));
                data.addGatewayInfo((GatewayInfo)gateway);
            });
        });
        return data;
    }

    private GatewayInfo extractGatewayInfo(JsonObject lrr) {
        GatewayInfo gateway = new GatewayInfo();
        LoraUtils.getChildObject(lrr, "Lrrid", String.class).ifPresent(gateway::setGatewayId);
        LoraUtils.getChildObject(lrr, "LrrRSSI", Double.class).ifPresent(d -> gateway.setRssi(d.intValue()));
        LoraUtils.getChildObject(lrr, "LrrSNR", Double.class).ifPresent(d -> gateway.setSnr((Double)d));
        return gateway;
    }
}

