/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.adapter.lora.LoraCommand;
import org.eclipse.hono.adapter.lora.LoraMessage;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.UplinkLoraMessage;
import org.eclipse.hono.adapter.lora.providers.LoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.util.CommandEndpoint;
import org.eclipse.hono.util.Strings;

public abstract class JsonBasedLoraProvider
implements LoraProvider {
    private static final String FIELD_PAYLOAD = "payload";

    @Override
    public LoraMessage getMessage(RoutingContext ctx) {
        Objects.requireNonNull(ctx);
        try {
            Buffer requestBody = ctx.body().buffer();
            JsonObject message = requestBody.toJsonObject();
            LoraMessageType type = this.getMessageType(message);
            switch (type) {
                case UPLINK: {
                    return this.createUplinkMessage(ctx.request(), message);
                }
            }
            throw new LoraProviderMalformedPayloadException(String.format("unsupported message type [%s]", new Object[]{type}));
        }
        catch (RuntimeException e) {
            throw new LoraProviderMalformedPayloadException("failed to decode request body", e);
        }
    }

    @Override
    public LoraCommand getCommand(CommandEndpoint commandEndpoint, String deviceId, Buffer payload, String subject) {
        Objects.requireNonNull(commandEndpoint);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(payload);
        Objects.requireNonNull(subject);
        if (Strings.isNullOrEmpty((Object)commandEndpoint.getUri())) {
            throw new IllegalArgumentException("command endpoint uri is empty");
        }
        JsonObject commandPayload = this.getCommandPayload(payload, deviceId, subject);
        commandEndpoint.getPayloadProperties().forEach((arg_0, arg_1) -> ((JsonObject)commandPayload).put(arg_0, arg_1));
        return new LoraCommand(commandPayload, commandEndpoint.getFormattedUri(deviceId));
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return Map.of();
    }

    protected JsonObject getCommandPayload(Buffer payload, String deviceId, String subject) {
        JsonObject json = new JsonObject();
        json.put(FIELD_PAYLOAD, (Object)BaseEncoding.base16().encode(payload.getBytes()));
        return json;
    }

    protected abstract LoraMessageType getMessageType(JsonObject var1);

    protected abstract String getDevEui(JsonObject var1);

    protected abstract Buffer getPayload(JsonObject var1);

    protected LoraMetaData getMetaData(JsonObject uplinkMessage) {
        return null;
    }

    protected JsonObject getAdditionalData(JsonObject uplinkMessage) {
        return uplinkMessage;
    }

    protected UplinkLoraMessage createUplinkMessage(HttpServerRequest request, JsonObject requestBody) {
        Objects.requireNonNull(requestBody);
        String devEui = this.getDevEui(requestBody);
        UplinkLoraMessage message = new UplinkLoraMessage(devEui);
        message.setPayload(this.getPayload(requestBody));
        message.setMetaData(this.getMetaData(requestBody));
        message.setAdditionalData(this.getAdditionalData(requestBody));
        return message;
    }
}

