/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.lora.LoraMessage;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;

public class UplinkLoraMessage
implements LoraMessage {
    private final byte[] devEui;
    private final String devEuiAsString;
    private Buffer payload;
    private LoraMetaData metaData = null;
    private JsonObject additionalData;

    public UplinkLoraMessage(byte[] devEui) {
        Objects.requireNonNull(devEui);
        if (devEui.length != 8) {
            throw new IllegalArgumentException("devEUI must be 64 bits long");
        }
        this.devEui = devEui;
        this.devEuiAsString = BaseEncoding.base16().encode(devEui);
    }

    public UplinkLoraMessage(String devEui) {
        Objects.requireNonNull(devEui);
        if (devEui.length() != 16) {
            throw new IllegalArgumentException("devEUI must be 64 bits long");
        }
        this.devEuiAsString = devEui;
        this.devEui = BaseEncoding.base16().decode((CharSequence)devEui.toUpperCase());
    }

    @Override
    public final byte[] getDevEUI() {
        return this.devEui;
    }

    @Override
    public final String getDevEUIAsString() {
        return this.devEuiAsString;
    }

    @Override
    public final LoraMessageType getType() {
        return LoraMessageType.UPLINK;
    }

    @Override
    public final Buffer getPayload() {
        return this.payload;
    }

    public final void setPayload(Buffer payload) {
        this.payload = Objects.requireNonNull(payload);
    }

    public final LoraMetaData getMetaData() {
        return this.metaData;
    }

    public final void setMetaData(LoraMetaData data) {
        this.metaData = data;
    }

    public final JsonObject getAdditionalData() {
        return this.additionalData;
    }

    public final void setAdditionalData(JsonObject data) {
        this.additionalData = data;
    }
}

