/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.lora.providers;

import com.google.common.io.BaseEncoding;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.hono.adapter.lora.GatewayInfo;
import org.eclipse.hono.adapter.lora.LoraMessageType;
import org.eclipse.hono.adapter.lora.LoraMetaData;
import org.eclipse.hono.adapter.lora.providers.JsonBasedLoraProvider;
import org.eclipse.hono.adapter.lora.providers.LoraProviderMalformedPayloadException;
import org.eclipse.hono.adapter.lora.providers.LoraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LoriotProvider
extends JsonBasedLoraProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LoriotProvider.class);
    private static final Pattern PATTERN_DATA_RATE = Pattern.compile("^SF(\\d+) BW(\\d+) (.+)$");
    private static final String FIELD_LORIOT_DATARATE = "dr";
    private static final String FIELD_LORIOT_EUI = "EUI";
    private static final String FIELD_LORIOT_FRAME_COUNT = "fcnt";
    private static final String FIELD_LORIOT_FREQUENCY = "freq";
    private static final String FIELD_LORIOT_FUNCTION_PORT = "port";
    private static final String FIELD_LORIOT_GATEWAY_EUI = "gweui";
    private static final String FIELD_LORIOT_LATITUDE = "lat";
    private static final String FIELD_LORIOT_LONGITUDE = "lon";
    private static final String FIELD_LORIOT_MESSAGE_TYPE = "cmd";
    private static final String FIELD_LORIOT_PAYLOAD = "data";
    private static final String FIELD_LORIOT_RSSI = "rssi";
    private static final String FIELD_LORIOT_SNR = "snr";
    private static final String COMMAND_FIELD_LORIOT_CMD = "cmd";
    private static final String COMMAND_FIELD_LORIOT_CONFIRMED = "confirmed";
    private static final String COMMAND_FIELD_LORIOT_DATA = "data";
    private static final String COMMAND_FIELD_LORIOT_EUI = "EUI";
    private static final String COMMAND_FIELD_LORIOT_PORT = "port";
    private static final String COMMAND_VALUE_LORIOT_TX = "tx";
    private static final String OBJECTS_LORIOT_GATEWAYS = "gws";
    private static final String MESSAGE_TYPE_UPLINK = "gw";

    @Override
    public String getProviderName() {
        return "loriot";
    }

    @Override
    public Set<String> pathPrefixes() {
        return Set.of("/loriot");
    }

    @Override
    protected String getDevEui(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, "EUI", String.class).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain String valued device ID property"));
    }

    @Override
    protected Buffer getPayload(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, "data", String.class).map(s -> Buffer.buffer((byte[])BaseEncoding.base16().decode((CharSequence)s.toUpperCase()))).orElseThrow(() -> new LoraProviderMalformedPayloadException("message does not contain String valued payload property"));
    }

    @Override
    protected LoraMessageType getMessageType(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        return LoraUtils.getChildObject(loraMessage, "cmd", String.class).filter(MESSAGE_TYPE_UPLINK::equals).map(s -> LoraMessageType.UPLINK).orElse(LoraMessageType.UNKNOWN);
    }

    @Override
    protected LoraMetaData getMetaData(JsonObject loraMessage) {
        Objects.requireNonNull(loraMessage);
        LoraMetaData data = new LoraMetaData();
        LoraUtils.getChildObject(loraMessage, "port", Integer.class).ifPresent(data::setFunctionPort);
        LoraUtils.getChildObject(loraMessage, FIELD_LORIOT_FRAME_COUNT, Integer.class).ifPresent(data::setFrameCount);
        LoraUtils.getChildObject(loraMessage, FIELD_LORIOT_FREQUENCY, Double.class).map(f -> f / 1000000.0).ifPresent(data::setFrequency);
        LoraUtils.getChildObject(loraMessage, FIELD_LORIOT_DATARATE, String.class).ifPresent(dataRate -> {
            Matcher matcher = PATTERN_DATA_RATE.matcher((CharSequence)dataRate);
            if (matcher.matches()) {
                data.setSpreadingFactor(Integer.parseInt(matcher.group(1)));
                data.setBandwidth(Integer.parseInt(matcher.group(2)));
                data.setCodingRate(matcher.group(3));
            } else {
                LOG.debug("invalid data rate [{}]", dataRate);
            }
        });
        LoraUtils.getChildObject(loraMessage, OBJECTS_LORIOT_GATEWAYS, JsonArray.class).ifPresent(gws -> gws.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).forEach(gw -> {
            GatewayInfo gwInfo = new GatewayInfo();
            LoraUtils.getChildObject(gw, FIELD_LORIOT_GATEWAY_EUI, String.class).ifPresent(gwInfo::setGatewayId);
            LoraUtils.getChildObject(gw, FIELD_LORIOT_RSSI, Integer.class).ifPresent(gwInfo::setRssi);
            LoraUtils.getChildObject(gw, FIELD_LORIOT_SNR, Double.class).ifPresent(gwInfo::setSnr);
            Optional.ofNullable(LoraUtils.newLocation(LoraUtils.getChildObject(gw, FIELD_LORIOT_LONGITUDE, Double.class), LoraUtils.getChildObject(gw, FIELD_LORIOT_LATITUDE, Double.class), Optional.empty())).ifPresent(gwInfo::setLocation);
            data.addGatewayInfo(gwInfo);
        }));
        return data;
    }

    @Override
    protected JsonObject getCommandPayload(Buffer payload, String deviceId, String subject) {
        JsonObject json = new JsonObject();
        json.put("cmd", (Object)COMMAND_VALUE_LORIOT_TX);
        json.put(COMMAND_FIELD_LORIOT_CONFIRMED, (Object)false);
        json.put("data", (Object)BaseEncoding.base16().encode(payload.getBytes()));
        json.put("EUI", (Object)deviceId);
        try {
            json.put("port", (Object)Integer.parseInt(subject));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return json;
    }

    @Override
    public Map<String, String> getDefaultHeaders() {
        return Map.of(HttpHeaders.CONTENT_TYPE.toString(), "application/json", HttpHeaders.ACCEPT.toString(), "text/plain");
    }
}

