/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.http.AuthHandlerTools;
import org.eclipse.hono.util.ExecutionContext;

public class HonoBasicAuthHandler
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements BasicAuthHandler {
    private final PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler;

    public HonoBasicAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, String realm) {
        this(authProvider, realm, (PreCredentialsValidationHandler<HttpContext>)((PreCredentialsValidationHandler)null));
    }

    public HonoBasicAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, String realm, PreCredentialsValidationHandler<HttpContext> preCredentialsValidationHandler) {
        super((AuthenticationProvider)Objects.requireNonNull(authProvider), HTTPAuthorizationHandler.Type.BASIC, realm);
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
    }

    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Base64.getDecoder().decode((String)parseAuthorization.result()), StandardCharsets.UTF_8);
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)new HttpException(400, (Throwable)e)));
                return;
            }
            final JsonObject credentials = new JsonObject().put("username", (Object)suser).put("password", (Object)spass);
            ExecutionContextAuthHandler<HttpContext> authHandler = new ExecutionContextAuthHandler<HttpContext>((DeviceCredentialsAuthProvider)this.authProvider, this.preCredentialsValidationHandler){

                public Future<JsonObject> parseCredentials(HttpContext context) {
                    return Future.succeededFuture((Object)credentials);
                }
            };
            authHandler.authenticateDevice((ExecutionContext)HttpContext.from((RoutingContext)context)).map(deviceUser -> deviceUser).onComplete(handler);
        });
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, this.getAuthenticateHeader());
    }

    private String getAuthenticateHeader() {
        if (this.realm != null && this.realm.length() > 0) {
            return String.valueOf(this.type) + " realm=\"" + this.realm + "\"";
        }
        return null;
    }
}

