/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http;

import java.util.Objects;
import org.eclipse.hono.adapter.ProtocolAdapterProperties;
import org.eclipse.hono.adapter.http.HttpProtocolAdapterOptions;

public class HttpProtocolAdapterProperties
extends ProtocolAdapterProperties {
    public static final String DEFAULT_REALM = "Hono";
    public static final int DEFAULT_IDLE_TIMEOUT_SECONDS = 75;
    private String realm = "Hono";
    private int idleTimeout = 75;

    public HttpProtocolAdapterProperties() {
    }

    public HttpProtocolAdapterProperties(HttpProtocolAdapterOptions options) {
        super(options.adapterOptions());
        this.realm = options.realm();
        this.idleTimeout = options.idleTimeout();
    }

    public final String getRealm() {
        return this.realm;
    }

    public final void setRealm(String realm) {
        this.realm = Objects.requireNonNull(realm);
    }

    public final int getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
    }
}

