/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.HttpContext;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordAuthProvider;
import org.eclipse.hono.adapter.auth.device.usernamepassword.UsernamePasswordCredentials;
import org.eclipse.hono.adapter.auth.device.x509.SubjectDnCredentials;
import org.eclipse.hono.adapter.auth.device.x509.TenantServiceBasedX509Authentication;
import org.eclipse.hono.adapter.auth.device.x509.X509AuthProvider;
import org.eclipse.hono.adapter.auth.device.x509.X509Authentication;
import org.eclipse.hono.adapter.http.AbstractVertxBasedHttpProtocolAdapter;
import org.eclipse.hono.adapter.http.HonoBasicAuthHandler;
import org.eclipse.hono.adapter.http.HttpProtocolAdapterProperties;
import org.eclipse.hono.adapter.http.X509AuthHandler;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public final class VertxBasedHttpProtocolAdapter
extends AbstractVertxBasedHttpProtocolAdapter<HttpProtocolAdapterProperties> {
    private static final String PARAM_TENANT = "tenant_id";
    private static final String PARAM_DEVICE_ID = "device_id";
    private static final String PARAM_COMMAND_REQUEST_ID = "cmd_req_id";
    private static final String ROUTE_TELEMETRY_ENDPOINT = "/telemetry";
    private static final String ROUTE_EVENT_ENDPOINT = "/event";
    private DeviceCredentialsAuthProvider<UsernamePasswordCredentials> usernamePasswordAuthProvider;
    private DeviceCredentialsAuthProvider<SubjectDnCredentials> clientCertAuthProvider;

    public void setUsernamePasswordAuthProvider(DeviceCredentialsAuthProvider<UsernamePasswordCredentials> provider) {
        this.usernamePasswordAuthProvider = Objects.requireNonNull(provider);
    }

    public void setClientCertAuthProvider(DeviceCredentialsAuthProvider<SubjectDnCredentials> provider) {
        this.clientCertAuthProvider = Objects.requireNonNull(provider);
    }

    public String getTypeName() {
        return "hono-http";
    }

    @Override
    protected void addRoutes(Router router) {
        if (((HttpProtocolAdapterProperties)((Object)this.getConfig())).isAuthenticationRequired()) {
            ChainAuthHandler authHandler = ChainAuthHandler.any();
            authHandler.add((AuthenticationHandler)new X509AuthHandler((X509Authentication)new TenantServiceBasedX509Authentication(this.getTenantClient(), this.tracer), (DeviceCredentialsAuthProvider<SubjectDnCredentials>)Optional.ofNullable(this.clientCertAuthProvider).orElseGet(() -> new X509AuthProvider(this.getCredentialsClient(), this.tracer)), (PreCredentialsValidationHandler<HttpContext>)((PreCredentialsValidationHandler)(x$0, x$1) -> this.handleBeforeCredentialsValidation(x$0, (HttpContext)x$1))));
            authHandler.add((AuthenticationHandler)new HonoBasicAuthHandler(Optional.ofNullable(this.usernamePasswordAuthProvider).orElseGet(() -> new UsernamePasswordAuthProvider(this.getCredentialsClient(), this.tracer)), ((HttpProtocolAdapterProperties)((Object)this.getConfig())).getRealm(), (PreCredentialsValidationHandler<HttpContext>)((PreCredentialsValidationHandler)(x$0, x$1) -> this.handleBeforeCredentialsValidation(x$0, (HttpContext)x$1))));
            this.addTelemetryApiRoutes(router, (Handler<RoutingContext>)authHandler);
            this.addEventApiRoutes(router, (Handler<RoutingContext>)authHandler);
            this.addCommandResponseRoutes(router, (Handler<RoutingContext>)authHandler);
        } else {
            this.log.warn("device authentication has been disabled");
            this.log.warn("any device may publish data on behalf of all other devices");
            this.addTelemetryApiRoutes(router, null);
            this.addEventApiRoutes(router, null);
            this.addCommandResponseRoutes(router, null);
        }
    }

    private void addTelemetryApiRoutes(Router router, Handler<RoutingContext> authHandler) {
        String telemetryPutPathWithParams = String.format("/telemetry/:%s/:%s", PARAM_TENANT, PARAM_DEVICE_ID);
        router.routeWithRegex("\\/telemetry\\/.+").handler((Handler)CorsHandler.create((String)((HttpProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.PUT).allowedHeader("QoS-Level").allowedHeader("hono-ttd").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).exposedHeader("hono-command").exposedHeader("hono-cmd-req-id")).setName("/telemetry (CORS)");
        if (((HttpProtocolAdapterProperties)((Object)this.getConfig())).isAuthenticationRequired()) {
            router.route(ROUTE_TELEMETRY_ENDPOINT).handler((Handler)CorsHandler.create((String)((HttpProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.POST).allowedHeader("QoS-Level").allowedHeader("hono-ttd").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).exposedHeader("hono-command").exposedHeader("hono-cmd-req-id")).setName("/telemetry (CORS)");
            router.post(ROUTE_TELEMETRY_ENDPOINT).handler(authHandler).handler((Handler)this.getBodyHandler());
            router.post(ROUTE_TELEMETRY_ENDPOINT).handler(this::handlePostTelemetry);
            router.put("/telemetry/*").handler(authHandler).setName(telemetryPutPathWithParams);
            router.put(telemetryPutPathWithParams).handler(this::assertTenant);
        }
        router.putWithRegex("\\/telemetry\\/.+").handler((Handler)this.getBodyHandler()).handler(this::handlePutTelemetry).setName(telemetryPutPathWithParams);
    }

    private void addEventApiRoutes(Router router, Handler<RoutingContext> authHandler) {
        String eventPutPathWithParams = String.format("/event/:%s/:%s", PARAM_TENANT, PARAM_DEVICE_ID);
        router.routeWithRegex("\\/event\\/.+").handler((Handler)CorsHandler.create((String)((HttpProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.PUT).allowedHeader("hono-ttd").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).exposedHeader("hono-command").exposedHeader("hono-cmd-req-id")).setName("/event (CORS)");
        if (((HttpProtocolAdapterProperties)((Object)this.getConfig())).isAuthenticationRequired()) {
            router.route(ROUTE_EVENT_ENDPOINT).handler((Handler)CorsHandler.create((String)((HttpProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.POST).allowedHeader("hono-ttd").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).exposedHeader("hono-command").exposedHeader("hono-cmd-req-id")).setName("/event (CORS)");
            router.post(ROUTE_EVENT_ENDPOINT).handler(authHandler).handler((Handler)this.getBodyHandler());
            router.post(ROUTE_EVENT_ENDPOINT).handler(this::handlePostTelemetry);
            router.put("/event/*").handler(authHandler).setName(eventPutPathWithParams);
            router.put(eventPutPathWithParams).handler(this::assertTenant);
        }
        router.putWithRegex("\\/event\\/.+").handler((Handler)this.getBodyHandler()).handler(this::handlePutTelemetry).setName(eventPutPathWithParams);
    }

    private void addCommandResponseRoutes(Router router, Handler<RoutingContext> authHandler) {
        String commandResponseMatchAllPath = "/command/res/*";
        String commandResponsePutPathWithParams = String.format("/command/res/:%s/:%s/:%s", PARAM_TENANT, PARAM_DEVICE_ID, PARAM_COMMAND_REQUEST_ID);
        CorsHandler corsHandler = CorsHandler.create((String)((HttpProtocolAdapterProperties)((Object)this.getConfig())).getCorsAllowedOrigin()).allowedMethod(HttpMethod.PUT).allowedHeader("hono-cmd-status").allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.CONTENT_TYPE.toString());
        router.route("/command/res/*").handler((Handler)corsHandler).setName("/command/res/* (CORS)");
        if (((HttpProtocolAdapterProperties)((Object)this.getConfig())).isAuthenticationRequired()) {
            corsHandler.allowedMethod(HttpMethod.POST);
            String commandResponsePostPathWithParam = String.format("/command/res/:%s", PARAM_COMMAND_REQUEST_ID);
            router.post("/command/res/*").handler(authHandler).handler((Handler)this.getBodyHandler()).setName(commandResponsePostPathWithParam);
            router.post(commandResponsePostPathWithParam).handler(this::handlePostCommandResponse);
            router.put("/command/res/*").handler(authHandler).setName(commandResponsePutPathWithParams);
            router.put(commandResponsePutPathWithParams).handler(this::assertTenant);
        }
        router.put("/command/res/*").handler((Handler)this.getBodyHandler()).handler(this::handlePutCommandResponse).setName(commandResponsePutPathWithParams);
    }

    private static String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT);
    }

    private static String getCommandRequestIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_COMMAND_REQUEST_ID);
    }

    private static Integer getCommandResponseStatusParam(RoutingContext ctx) {
        return HttpUtils.getCommandResponseStatus((RoutingContext)ctx).orElse(null);
    }

    private void handle401(RoutingContext ctx) {
        HttpUtils.unauthorized((RoutingContext)ctx, (String)("Basic realm=\"" + ((HttpProtocolAdapterProperties)((Object)this.getConfig())).getRealm() + "\""));
    }

    void handlePostTelemetry(RoutingContext ctx) {
        User user = ctx.user();
        if (user instanceof Device) {
            Device authenticatedDevice = (Device)user;
            this.doUploadMessage(HttpContext.from((RoutingContext)ctx), authenticatedDevice.getTenantId(), authenticatedDevice.getDeviceId());
        } else {
            this.handle401(ctx);
        }
    }

    void handlePutTelemetry(RoutingContext ctx) {
        HttpContext httpContext = HttpContext.from((RoutingContext)ctx);
        ResourceIdentifier requestedResource = httpContext.getRequestedResource();
        if (Strings.isNullOrEmpty((Object)requestedResource.getResourceId())) {
            HttpUtils.notFound((RoutingContext)ctx, (String)"request URI must contain device ID");
        } else {
            User user = ctx.user();
            if (user instanceof Device) {
                Device authenticatedDevice = (Device)user;
                this.doUploadMessage(httpContext, authenticatedDevice.getTenantId(), requestedResource.getResourceId());
            } else if (Strings.isNullOrEmpty((Object)requestedResource.getTenantId())) {
                HttpUtils.notFound((RoutingContext)ctx, (String)"request URI must contain tenant ID");
            } else {
                this.doUploadMessage(httpContext, requestedResource.getTenantId(), requestedResource.getResourceId());
            }
        }
    }

    void handlePostCommandResponse(RoutingContext ctx) {
        User user = ctx.user();
        if (user instanceof Device) {
            Device authenticatedDevice = (Device)user;
            this.uploadCommandResponseMessage(HttpContext.from((RoutingContext)ctx), authenticatedDevice.getTenantId(), authenticatedDevice.getDeviceId(), VertxBasedHttpProtocolAdapter.getCommandRequestIdParam(ctx), VertxBasedHttpProtocolAdapter.getCommandResponseStatusParam(ctx));
        } else {
            this.handle401(ctx);
        }
    }

    void handlePutCommandResponse(RoutingContext ctx) {
        HttpContext httpContext = HttpContext.from((RoutingContext)ctx);
        ResourceIdentifier requestedResource = httpContext.getRequestedResource();
        String[] path = requestedResource.toPath();
        if (path.length < 5) {
            HttpUtils.notFound((RoutingContext)ctx, (String)"request URI must contain tenant, device and request ID");
            return;
        }
        String tenantId = path[2];
        String deviceId = path[3];
        String requestId = path[4];
        if (Strings.isNullOrEmpty((Object)deviceId)) {
            HttpUtils.notFound((RoutingContext)ctx, (String)"request URI must contain device ID");
        } else {
            User user = ctx.user();
            if (user instanceof Device) {
                Device authenticatedDevice = (Device)user;
                this.uploadCommandResponseMessage(httpContext, authenticatedDevice.getTenantId(), deviceId, requestId, VertxBasedHttpProtocolAdapter.getCommandResponseStatusParam(ctx));
            } else if (Strings.isNullOrEmpty((Object)tenantId)) {
                HttpUtils.notFound((RoutingContext)ctx, (String)"request URI must contain tenant ID");
            } else {
                this.uploadCommandResponseMessage(httpContext, tenantId, deviceId, requestId, VertxBasedHttpProtocolAdapter.getCommandResponseStatusParam(ctx));
            }
        }
    }

    void assertTenant(RoutingContext ctx) {
        User user = ctx.user();
        if (user instanceof Device) {
            Device authenticatedDevice = (Device)user;
            if (authenticatedDevice.getTenantId().equals(VertxBasedHttpProtocolAdapter.getTenantParam(ctx))) {
                ctx.next();
            } else {
                ctx.fail((Throwable)new ClientErrorException(403, "not authorized to upload data for device from other tenant"));
            }
        } else {
            this.handle401(ctx);
        }
    }
}

