/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.http;

import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.util.Optional;
import org.eclipse.hono.client.ServiceInvocationException;

public final class AuthHandlerTools {
    private AuthHandlerTools() {
    }

    public static void processException(RoutingContext ctx, Throwable exception, String authenticateHeader) {
        if (exception instanceof HttpException) {
            String payload;
            int statusCode;
            Throwable failure = Optional.ofNullable(exception.getCause()).map(c -> {
                if (c instanceof ServiceInvocationException) {
                    return c;
                }
                return exception;
            }).orElse(exception);
            if (failure instanceof ServiceInvocationException) {
                ServiceInvocationException sie = (ServiceInvocationException)exception.getCause();
                statusCode = sie.getErrorCode();
                payload = null;
            } else {
                statusCode = ((HttpException)exception).getStatusCode();
                payload = ((HttpException)exception).getPayload();
            }
            switch (statusCode) {
                case 302: {
                    ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(302).end("Redirecting to " + payload + ".");
                    return;
                }
                case 401: {
                    if (authenticateHeader == null) break;
                    ctx.response().putHeader("WWW-Authenticate", authenticateHeader);
                }
            }
            ctx.fail(failure);
        } else {
            ctx.fail(exception);
        }
    }
}

