/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.CertificateAuthenticationMode;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.UdpConfig;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.dtls.x509.SingleCertificateProvider;
import org.eclipse.hono.adapter.coap.CoapAdapterProperties;
import org.eclipse.hono.adapter.coap.CoapEndpointFactory;
import org.eclipse.hono.adapter.coap.DeviceInfoSupplier;
import org.eclipse.hono.adapter.limiting.MemoryBasedConnectionLimitStrategy;
import org.eclipse.hono.config.KeyLoader;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigBasedCoapEndpointFactory
implements CoapEndpointFactory {
    private static final int MINIMAL_MEMORY_JVM = 100000000;
    private static final int MINIMAL_MEMORY_SUBSTRATE = 35000000;
    private static final int MEMORY_PER_CONNECTION = 10000;
    private static final Logger LOG;
    private final CoapAdapterProperties config;
    private final Vertx vertx;
    private AdvancedPskStore pskStore;
    private NewAdvancedCertificateVerifier certificateVerifier;
    private ApplicationLevelInfoSupplier deviceResolver = new DeviceInfoSupplier();
    private ObservationStore observationStore;

    public ConfigBasedCoapEndpointFactory(Vertx vertx, CoapAdapterProperties config) {
        this.vertx = Objects.requireNonNull(vertx);
        this.config = Objects.requireNonNull(config);
    }

    public void setPskStore(AdvancedPskStore store) {
        this.pskStore = Objects.requireNonNull(store);
    }

    public void setDeviceResolver(ApplicationLevelInfoSupplier resolver) {
        this.deviceResolver = Objects.requireNonNull(resolver);
    }

    public final void setCertificateVerifier(NewAdvancedCertificateVerifier certificateVerifier) {
        this.certificateVerifier = Objects.requireNonNull(certificateVerifier);
    }

    public void setObservationStore(ObservationStore store) {
        this.observationStore = Objects.requireNonNull(store);
    }

    @Override
    public Future<Configuration> getCoapServerConfiguration() {
        Configuration networkConfig = this.newDefaultConfiguration();
        return this.loadConfiguration(this.config.getNetworkConfig(), networkConfig);
    }

    private boolean isSecurePortEnabled() {
        return this.config.isSecurePortEnabled() || this.config.getPort() > -1;
    }

    private Configuration newDefaultConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set((BasicDefinition)CoapConfig.PROTOCOL_STAGE_THREAD_COUNT, (Object)this.config.getCoapThreads());
        configuration.set((BasicDefinition)CoapConfig.MAX_RESOURCE_BODY_SIZE, (Object)this.config.getMaxPayloadSize());
        configuration.set(CoapConfig.EXCHANGE_LIFETIME, this.config.getExchangeLifetime(), TimeUnit.MILLISECONDS);
        configuration.set(CoapConfig.BLOCKWISE_STATUS_LIFETIME, this.config.getBlockwiseStatusLifetime(), TimeUnit.MILLISECONDS);
        configuration.set((BasicDefinition)CoapConfig.USE_MESSAGE_OFFLOADING, (Object)this.config.isMessageOffloadingEnabled());
        configuration.set((BasicDefinition)CoapConfig.DEDUPLICATOR, (Object)"PEERS_MARK_AND_SWEEP");
        int maxConnections = this.config.getMaxConnections();
        if (maxConnections == 0) {
            MemoryBasedConnectionLimitStrategy limits = MemoryBasedConnectionLimitStrategy.forParams((long)(this.config.isSubstrateVm() ? 35000000L : 100000000L), (long)10000L, (int)this.config.getGcHeapPercentage());
            configuration.set((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS, (Object)limits.getRecommendedLimit());
        } else {
            configuration.set((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS, (Object)maxConnections);
        }
        return configuration;
    }

    protected Future<Configuration> loadConfiguration(String fileName, Configuration config) {
        Promise result = Promise.promise();
        if (!Strings.isNullOrEmpty((Object)fileName)) {
            this.vertx.fileSystem().readFile(fileName, readAttempt -> {
                if (readAttempt.succeeded()) {
                    try (ByteArrayInputStream is = new ByteArrayInputStream(((Buffer)readAttempt.result()).getBytes());){
                        config.load((InputStream)is);
                        result.complete((Object)config);
                    }
                    catch (IOException e) {
                        LOG.warn("error malformed Configuration properties [{}]", (Object)fileName);
                        result.fail((Throwable)e);
                    }
                } else {
                    LOG.warn("error reading Configuration file [{}]", (Object)fileName, (Object)readAttempt.cause());
                    result.fail(readAttempt.cause());
                }
            });
        } else {
            result.complete((Object)config);
        }
        return result.future();
    }

    protected Future<Configuration> getSecureConfiguration() {
        Configuration networkConfig = this.newDefaultConfiguration();
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_RECEIVER_THREAD_COUNT, (Object)this.config.getConnectorThreads());
        networkConfig.set((BasicDefinition)DtlsConfig.DTLS_CONNECTOR_THREAD_COUNT, (Object)this.config.getDtlsThreads());
        return this.loadConfiguration(this.config.getNetworkConfig(), networkConfig).compose(c -> this.loadConfiguration(this.config.getSecureNetworkConfig(), (Configuration)c));
    }

    protected Future<Configuration> getInsecureConfiguration() {
        Configuration configuration = this.newDefaultConfiguration();
        configuration.set((BasicDefinition)UdpConfig.UDP_RECEIVER_THREAD_COUNT, (Object)this.config.getConnectorThreads());
        configuration.set((BasicDefinition)UdpConfig.UDP_SENDER_THREAD_COUNT, (Object)this.config.getConnectorThreads());
        return this.loadConfiguration(this.config.getNetworkConfig(), configuration).compose(c -> this.loadConfiguration(this.config.getInsecureNetworkConfig(), (Configuration)c));
    }

    @Override
    public Future<Endpoint> getInsecureEndpoint() {
        Promise result = Promise.promise();
        if (this.config.isInsecurePortEnabled()) {
            if (this.config.isAuthenticationRequired()) {
                LOG.debug("skipping creation of insecure endpoint, configuration requires authentication of devices");
                result.fail("configuration requires authentication of devices");
            } else {
                int securePort;
                int insecurePort = this.config.getInsecurePort(5683);
                int n = securePort = this.isSecurePortEnabled() ? this.config.getPort(5684) : -1;
                if (this.isSecurePortEnabled() && securePort == insecurePort) {
                    LOG.error("secure and insecure ports must be configured to bind to different port numbers");
                    result.fail("secure and insecure ports configured to bind to same port number");
                } else {
                    this.createInsecureEndpoint(insecurePort).onComplete((Handler)result);
                }
            }
        } else if (!this.isSecurePortEnabled()) {
            result.fail((Throwable)new IllegalStateException("neither secure nor insecure port configured"));
        } else {
            LOG.info("insecure port is not configured, won't create insecure endpoint");
            result.fail((Throwable)new IllegalStateException("insecure port is not configured"));
        }
        return result.future();
    }

    private Future<Endpoint> createInsecureEndpoint(int port) {
        LOG.info("creating insecure endpoint");
        return this.getInsecureConfiguration().map(networkConfig -> {
            CoapEndpoint.Builder builder = CoapEndpoint.builder();
            builder.setConfiguration(networkConfig);
            builder.setInetSocketAddress(new InetSocketAddress(this.config.getInsecurePortBindAddress(), port));
            builder.setObservationStore(this.observationStore);
            return builder.build();
        });
    }

    @Override
    public Future<Endpoint> getSecureEndpoint() {
        Promise result = Promise.promise();
        if (this.isSecurePortEnabled()) {
            int insecurePort;
            int securePort = this.config.getPort(5684);
            int n = insecurePort = this.config.isInsecurePortEnabled() ? this.config.getInsecurePort(5683) : -1;
            if (this.config.isInsecurePortEnabled() && insecurePort == securePort) {
                LOG.error("secure and insecure ports must be configured to bind to different port numbers");
                result.fail("secure and insecure ports configured to bind to same port number");
            } else {
                this.getSecureConfiguration().compose(secureNetworkConfig -> this.createSecureEndpoint(securePort, (Configuration)secureNetworkConfig)).onComplete((Handler)result);
            }
        } else if (!this.config.isInsecurePortEnabled()) {
            result.fail((Throwable)new IllegalStateException("neither secure nor insecure port configured"));
        } else {
            LOG.info("neither key/cert nor secure port are configured, won't create secure endpoint");
            result.fail((Throwable)new IllegalStateException("neither key/cert nor secure port are configured"));
        }
        return result.future();
    }

    private Future<Endpoint> createSecureEndpoint(int port, Configuration networkConfig) {
        if (this.deviceResolver == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("infoSupplier property must be set for secure endpoint"));
        }
        if (this.pskStore == null) {
            return Future.failedFuture((Throwable)new IllegalStateException("pskStore property must be set for secure endpoint"));
        }
        LOG.info("creating secure endpoint");
        DtlsConnectorConfig.Builder dtlsConfig = DtlsConnectorConfig.builder((Configuration)networkConfig);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_SERVER_USE_SESSION_ID, (Object)false);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_ROLE, (Object)DtlsConfig.DtlsRole.SERVER_ONLY);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)true);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_CLIENT_AUTHENTICATION_MODE, (Object)CertificateAuthenticationMode.NEEDED);
        dtlsConfig.set(DtlsConfig.DTLS_RETRANSMISSION_TIMEOUT, this.config.getDtlsRetransmissionTimeout(), TimeUnit.MILLISECONDS);
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_MAX_CONNECTIONS, (Object)((Integer)networkConfig.get((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS)));
        dtlsConfig.set((BasicDefinition)DtlsConfig.DTLS_USE_SERVER_NAME_INDICATION, (Object)true);
        dtlsConfig.setAddress(new InetSocketAddress(this.config.getBindAddress(), port));
        dtlsConfig.setApplicationLevelInfoSupplier(this.deviceResolver);
        dtlsConfig.setAdvancedPskStore(this.pskStore);
        this.addIdentity(dtlsConfig);
        try {
            DtlsConnectorConfig dtlsConnectorConfig = dtlsConfig.build();
            if (LOG.isInfoEnabled()) {
                String ciphers = dtlsConnectorConfig.getSupportedCipherSuites().stream().map(cipher -> cipher.name()).collect(Collectors.joining(", "));
                LOG.info("creating secure endpoint supporting ciphers: {}", (Object)ciphers);
            }
            DTLSConnector dtlsConnector = new DTLSConnector(dtlsConnectorConfig);
            CoapEndpoint.Builder builder = CoapEndpoint.builder();
            builder.setConfiguration(networkConfig);
            builder.setConnector((Connector)dtlsConnector);
            builder.setObservationStore(this.observationStore);
            return Future.succeededFuture((Object)builder.build());
        }
        catch (IllegalStateException ex) {
            LOG.warn("failed to create secure endpoint", (Throwable)ex);
            return Future.failedFuture((Throwable)ex);
        }
    }

    private void addIdentity(DtlsConnectorConfig.Builder dtlsConfig) {
        KeyLoader keyLoader = KeyLoader.fromFiles((Vertx)this.vertx, (String)this.config.getKeyPath(), (String)this.config.getCertPath());
        PrivateKey pk = keyLoader.getPrivateKey();
        Certificate[] certChain = keyLoader.getCertificateChain();
        if (pk == null) {
            LOG.warn("no private private key configured");
        } else if (certChain == null) {
            LOG.warn("no server certificate configured");
        } else if (pk.getAlgorithm().equals("EC")) {
            LOG.info("using private key [{}] and certificate [{}] as server identity", (Object)this.config.getKeyPath(), (Object)this.config.getCertPath());
            dtlsConfig.setCertificateIdentityProvider((CertificateProvider)new SingleCertificateProvider(pk, certChain, new CertificateType[0]));
            Optional.ofNullable(this.certificateVerifier).ifPresent(arg_0 -> ((DtlsConnectorConfig.Builder)dtlsConfig).setAdvancedCertificateVerifier(arg_0));
        } else {
            LOG.warn("configured key is not ECC based, certificate based cipher suites will be disabled");
        }
    }

    static {
        CoapConfig.register();
        DtlsConfig.register();
        UdpConfig.register();
        LOG = LoggerFactory.getLogger(ConfigBasedCoapEndpointFactory.class);
    }
}

