/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.hono.adapter.coap.AbstractHonoResource;
import org.eclipse.hono.adapter.coap.CoapContext;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.metric.MetricsTags;

public class EventResource
extends AbstractHonoResource {
    private static final String SPAN_NAME_DEFAULT = "/%s/*".formatted("event");
    private static final String SPAN_NAME_POST = "/%s".formatted("event");
    private static final String SPAN_NAME_PUT = "/%s/:tenant_id/:device_id".formatted("event");

    public EventResource(CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        this("event", adapter, tracer, vertx);
    }

    public EventResource(String resourceName, CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        super(resourceName, adapter, tracer, vertx);
    }

    @Override
    protected String getSpanName(Exchange exchange) {
        switch (exchange.getRequest().getCode()) {
            case POST: {
                return SPAN_NAME_POST;
            }
            case PUT: {
                return SPAN_NAME_PUT;
            }
        }
        return SPAN_NAME_DEFAULT;
    }

    @Override
    public Future<Void> handlePostRequest(CoapContext ctx) {
        return this.uploadEventMessage(ctx);
    }

    @Override
    public Future<Void> handlePutRequest(CoapContext ctx) {
        return this.uploadEventMessage(ctx);
    }

    private Future<Void> uploadEventMessage(CoapContext context) {
        Objects.requireNonNull(context);
        if (context.isConfirmable()) {
            return this.doUploadMessage(context, MetricsTags.EndpointType.EVENT);
        }
        return Future.failedFuture((Throwable)new ClientErrorException(400, "event endpoint supports confirmable request messages only"));
    }
}

