/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.hono.adapter.auth.device.DeviceCredentials;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.adapter.coap.DeviceInfoSupplier;
import org.eclipse.hono.adapter.coap.PreSharedKeyDeviceIdentity;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.tracing.TenantTraceSamplingHelper;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CredentialsObject;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRegistryBasedPskStore
implements AdvancedPskStore {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceRegistryBasedPskStore.class);
    private final CoapProtocolAdapter adapter;
    private final Tracer tracer;
    private volatile HandshakeResultHandler californiumResultHandler;

    public DeviceRegistryBasedPskStore(CoapProtocolAdapter adapter, Tracer tracer) {
        this.adapter = Objects.requireNonNull(adapter);
        this.tracer = Objects.requireNonNull(tracer);
    }

    private static SecretKey getCandidateKey(CredentialsObject credentialsOnRecord) {
        return credentialsOnRecord.getCandidateSecrets(candidateSecret -> DeviceRegistryBasedPskStore.getKey(candidateSecret)).stream().findFirst().orElse(null);
    }

    private static SecretKey getKey(JsonObject candidateSecret) {
        try {
            byte[] encodedKey = candidateSecret.getBinary("key");
            SecretKey key = SecretUtil.create((byte[])encodedKey, (String)"PSK");
            Arrays.fill(encodedKey, (byte)0);
            return key;
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return null;
        }
    }

    private void loadCredentialsForDevice(ConnectionId cid, PskPublicInformation identity) {
        String publicInfo = identity.getPublicInfoAsString();
        LOG.debug("getting PSK secret for identity [{}]", (Object)publicInfo);
        Span span = this.tracer.buildSpan("look up pre-shared key").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.COMPONENT.getKey(), this.adapter.getTypeName()).start();
        PreSharedKeyDeviceIdentity handshakeIdentity = this.getHandshakeIdentity(publicInfo, span);
        if (handshakeIdentity == null) {
            TracingHelper.logError((Span)span, (String)"could not determine auth-id from PSK identity");
            span.finish();
            return;
        }
        TracingHelper.TAG_TENANT_ID.set(span, handshakeIdentity.getTenantId());
        TracingHelper.TAG_AUTH_ID.set(span, handshakeIdentity.getAuthId());
        this.applyTraceSamplingPriority(handshakeIdentity, span).compose(v -> this.adapter.getCredentialsClient().get(handshakeIdentity.getTenantId(), handshakeIdentity.getType(), handshakeIdentity.getAuthId(), new JsonObject(), span.context())).map(credentials -> {
            String deviceId = credentials.getDeviceId();
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            SecretKey key = DeviceRegistryBasedPskStore.getCandidateKey(credentials);
            if (key == null) {
                TracingHelper.logError((Span)span, (String)"PSK credentials for device do not contain proper key");
                return new PskSecretResult(cid, identity, null, null);
            }
            span.log("successfully retrieved PSK for device");
            AdditionalInfo info = DeviceInfoSupplier.createDeviceInfo(new DeviceUser(handshakeIdentity.getTenantId(), credentials.getDeviceId()), handshakeIdentity.getAuthId());
            return new PskSecretResult(cid, identity, key, (Object)info);
        }).otherwise(t -> {
            TracingHelper.logError((Span)span, (String)"could not retrieve PSK credentials for device", (Throwable)t);
            LOG.debug("error retrieving credentials for PSK identity [{}]", (Object)publicInfo, t);
            return new PskSecretResult(cid, identity, null, null);
        }).onSuccess(result -> {
            span.finish();
            this.californiumResultHandler.apply((HandshakeResult)result);
        });
    }

    private Future<Void> applyTraceSamplingPriority(DeviceCredentials deviceCredentials, Span span) {
        return this.adapter.getTenantClient().get(deviceCredentials.getTenantId(), span.context()).map(tenantObject -> {
            TracingHelper.setDeviceTags((Span)span, (String)tenantObject.getTenantId(), null, (String)deviceCredentials.getAuthId());
            TenantTraceSamplingHelper.applyTraceSamplingPriority((TenantObject)tenantObject, (String)deviceCredentials.getAuthId(), (Span)span);
            return null;
        }).recover(t -> Future.succeededFuture());
    }

    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        throw new UnsupportedOperationException("this adapter does not support DTLS client role");
    }

    private PreSharedKeyDeviceIdentity getHandshakeIdentity(String identity, Span span) {
        return PreSharedKeyDeviceIdentity.create(identity, this.adapter.getConfig().getIdSplitRegex(), span);
    }

    public boolean hasEcdhePskSupported() {
        return true;
    }

    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        this.adapter.runOnContext((Handler<Void>)((Handler)v -> this.loadCredentialsForDevice(cid, identity)));
        return null;
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
        this.californiumResultHandler = resultHandler;
    }
}

