/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.Optional;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptorAdapter;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.auth.AbstractExtensiblePrincipal;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.hono.adapter.coap.CoapConstants;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalErrorTracer
extends MessageInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(InternalErrorTracer.class);
    private final String coapAdapterName;
    private final Tracer tracer;

    public InternalErrorTracer(String coapAdapterName, Tracer tracer) {
        this.coapAdapterName = coapAdapterName;
        this.tracer = tracer;
    }

    public void sendResponse(Response response) {
        if (response.isInternal() && response.isError()) {
            EndpointContext context = response.getDestinationContext();
            AdditionalInfo honoInfo = Optional.ofNullable(context.getPeerIdentity()).filter(AbstractExtensiblePrincipal.class::isInstance).map(AbstractExtensiblePrincipal.class::cast).map(AbstractExtensiblePrincipal::getExtendedInfo).orElse(null);
            if (honoInfo == null) {
                LOG.debug("CoAP internal error has occured, but Hono context info is not set in the response [{}]", (Object)response.getCode().name());
                return;
            }
            String authId = (String)honoInfo.get("hono-auth-id", String.class);
            Device deviceInfo = (Device)honoInfo.get("hono-device", Device.class);
            String deviceId = deviceInfo.getDeviceId();
            String tenantId = deviceInfo.getTenantId();
            Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, null, (String)response.getCode().toString(), (String)this.coapAdapterName).withTag((Tag)TracingHelper.TAG_AUTH_ID, (Object)authId).withTag((Tag)TracingHelper.TAG_DEVICE_ID, (Object)deviceId).withTag((Tag)TracingHelper.TAG_TENANT_ID, (Object)tenantId).withTag((Tag)CoapConstants.TAG_COAP_MESSAGE_TYPE, (Object)response.getType().name()).start();
            TracingHelper.logError((Span)span, (String)"CoAP Internal error");
            span.finish();
        }
    }
}

