/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.coap;

import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.adapter.coap.AbstractHonoResource;
import org.eclipse.hono.adapter.coap.CoapContext;
import org.eclipse.hono.adapter.coap.CoapProtocolAdapter;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.metric.MetricsTags;

public class EventResource
extends AbstractHonoResource {
    public EventResource(CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        this("event", adapter, tracer, vertx);
    }

    public EventResource(String resourceName, CoapProtocolAdapter adapter, Tracer tracer, Vertx vertx) {
        super(resourceName, adapter, tracer, vertx);
    }

    @Override
    public Future<Void> handlePostRequest(CoapContext ctx) {
        return this.uploadEventMessage(ctx);
    }

    @Override
    public Future<Void> handlePutRequest(CoapContext ctx) {
        return this.uploadEventMessage(ctx);
    }

    private Future<Void> uploadEventMessage(CoapContext context) {
        Objects.requireNonNull(context);
        if (context.isConfirmable()) {
            return this.doUploadMessage(context, MetricsTags.EndpointType.EVENT);
        }
        return Future.failedFuture((Throwable)new ClientErrorException(400, "event endpoint supports confirmable request messages only"));
    }
}

