/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.jsonwebtoken.Claims;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.CredentialsApiAuthProvider;
import org.eclipse.hono.adapter.auth.device.jwt.JwsValidator;
import org.eclipse.hono.adapter.auth.device.jwt.JwtCredentials;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.util.CredentialsObject;

public class JwtAuthProvider
extends CredentialsApiAuthProvider<JwtCredentials> {
    private static final Duration ALLOWED_CLOCK_SKEW = Duration.ofMinutes(10L);
    private final JwsValidator tokenValidator;

    public JwtAuthProvider(CredentialsClient credentialsClient, JwsValidator tokenValidator, Tracer tracer) {
        super(credentialsClient, tracer);
        this.tokenValidator = Objects.requireNonNull(tokenValidator);
    }

    @Override
    public JwtCredentials getCredentials(JsonObject authInfo) {
        Objects.requireNonNull(authInfo);
        try {
            String tenantId = authInfo.getString("tenant-id");
            String authId = authInfo.getString("auth-id");
            String jws = authInfo.getString("password");
            if (tenantId == null || authId == null || jws == null) {
                return null;
            }
            JsonObject clientContext = authInfo.copy();
            clientContext.remove("tenant-id");
            clientContext.remove("auth-id");
            clientContext.remove("password");
            return JwtCredentials.create(tenantId, authId, jws, clientContext);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            this.log.debug("Reading authInfo failed", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Future<DeviceUser> doValidateCredentials(JwtCredentials deviceCredentials, CredentialsObject credentialsOnRecord) {
        return this.tokenValidator.expand(deviceCredentials.getJws(), credentialsOnRecord.getCandidateSecrets(), ALLOWED_CLOCK_SKEW).map(claims -> {
            final Instant expirationTime = ((Claims)claims.getPayload()).getExpiration().toInstant().plus(ALLOWED_CLOCK_SKEW);
            return new DeviceUser(deviceCredentials.getTenantId(), credentialsOnRecord.getDeviceId()){

                public boolean expired() {
                    return expirationTime.isBefore(Instant.now());
                }
            };
        });
    }
}

