/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.auth.device.jwt.JwsValidator;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJwsValidator
implements JwsValidator {
    private static final String EXPECTED_TOKEN_TYPE = "JWT";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwsValidator.class);

    private static JsonObject parseSection(String jws, int section) {
        Objects.requireNonNull(jws);
        if (section < 0 || section > 1) {
            throw new IllegalArgumentException("can only decode sections 0 (header) or 1 (body)");
        }
        String[] jwtSplit = jws.split("\\.", 3);
        if (jwtSplit.length != 3) {
            throw new MalformedJwtException("String is not a valid JWS structure");
        }
        try {
            Buffer p = Buffer.buffer((byte[])Base64.getUrlDecoder().decode(jwtSplit[section]));
            return new JsonObject(p);
        }
        catch (RuntimeException e) {
            throw new MalformedJwtException("Cannot parse JWS payload into JSON object", (Throwable)e);
        }
    }

    public static JsonObject getJwtClaims(String jws) {
        JsonObject claimsSection = DefaultJwsValidator.parseSection(jws, 1);
        LOG.debug("extracted claims from token: {}", (Object)claimsSection.encodePrettily());
        return claimsSection;
    }

    public static JsonObject getJwtHeader(String jws) {
        JsonObject headerSection = DefaultJwsValidator.parseSection(jws, 0);
        LOG.debug("extracted headers from token: {}", (Object)headerSection.encodePrettily());
        return headerSection;
    }

    private PublicKey convertPublicKeyByteArrayToPublicKey(JsonObject rawPublicKeySecret) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] encodedPublicKey = rawPublicKeySecret.getBinary("key");
        String alg = rawPublicKeySecret.getString("algorithm");
        X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(encodedPublicKey);
        return KeyFactory.getInstance(alg).generatePublic(keySpecX509);
    }

    private Jws<Claims> doExpand(String jws, List<JsonObject> candidateKeys, Duration allowedClockSkew) {
        Optional claims = candidateKeys.stream().mapMulti((spec, consumer) -> {
            try {
                PublicKey publicKey = this.convertPublicKeyByteArrayToPublicKey((JsonObject)spec);
                Jws claimsJws = Jwts.parser().clockSkewSeconds(allowedClockSkew.toSeconds()).verifyWith(publicKey).build().parseSignedClaims((CharSequence)jws);
                if (Objects.equals(((JwsHeader)claimsJws.getHeader()).getType(), EXPECTED_TOKEN_TYPE)) {
                    consumer.accept(claimsJws);
                } else {
                    LOG.debug("JWT must contain header [name: type, value: {}", (Object)EXPECTED_TOKEN_TYPE);
                }
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                LOG.debug("failed to create candidate public key [auth-id: {}]", (Object)spec.getString("auth-id"), (Object)e);
            }
            catch (JwtException e) {
                LOG.debug("failed to validate token using candidate key [auth-id: {}]", (Object)spec.getString("auth-id"), (Object)e);
            }
        }).findFirst();
        if (claims.isEmpty()) {
            throw new ClientErrorException(401);
        }
        try {
            this.assertAdditionalClaimsPolicy((Jws<Claims>)((Jws)claims.get()), allowedClockSkew);
            return (Jws)claims.get();
        }
        catch (JwtException e) {
            LOG.debug("failed to validate JWT's claims", (Throwable)e);
            throw new ClientErrorException(401, (Throwable)e);
        }
    }

    @Override
    public Future<Jws<Claims>> expand(String token, List<JsonObject> candidateKeys, Duration allowedClockSkew) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(candidateKeys);
        Objects.requireNonNull(allowedClockSkew);
        Context currentContext = Vertx.currentContext();
        if (currentContext == null) {
            try {
                return Future.succeededFuture(this.doExpand(token, candidateKeys, allowedClockSkew));
            }
            catch (ServiceInvocationException e) {
                return Future.failedFuture((Throwable)e);
            }
        }
        return currentContext.executeBlocking(() -> this.doExpand(token, candidateKeys, allowedClockSkew), true);
    }

    private void assertAdditionalClaimsPolicy(Jws<Claims> claims, Duration allowedClockSkew) {
        Instant iat = Optional.ofNullable(((Claims)claims.getPayload()).getIssuedAt()).map(Date::toInstant).orElseThrow(() -> new UnsupportedJwtException("JWT must contain iat claim"));
        Instant exp = Optional.ofNullable(((Claims)claims.getPayload()).getExpiration()).map(Date::toInstant).orElseThrow(() -> new UnsupportedJwtException("JWT must contain exp claim"));
        Instant latestStartOfValidity = Instant.now().plus(allowedClockSkew);
        int validityPeriodHours = 24;
        Instant endOfValidity = iat.plus(Duration.ofHours(24L)).plus(allowedClockSkew);
        if (iat.isAfter(latestStartOfValidity)) {
            throw new UnsupportedJwtException(String.format("iat must not be later than %s seconds from now", allowedClockSkew.toSeconds()));
        }
        if (!exp.isAfter(iat)) {
            throw new UnsupportedJwtException("exp must be after iat");
        }
        if (exp.isAfter(endOfValidity)) {
            throw new UnsupportedJwtException(String.format("exp must be at most %s hours after iat with a skew of %s seconds", 24, allowedClockSkew.toSeconds()));
        }
    }
}

