/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.TelemetryExecutionContext;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.http.HttpServerSpanHelper;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.EventConstants;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;

public final class HttpContext
implements TelemetryExecutionContext {
    private final RoutingContext routingContext;
    private final boolean eventEndpoint;
    private final QoS requestedQos;
    private final ResourceIdentifier requestedResource;

    private HttpContext(RoutingContext routingContext) {
        this.routingContext = Objects.requireNonNull(routingContext);
        this.requestedResource = Optional.ofNullable(routingContext.request().path()).map(path -> {
            String resourcePath = path.substring(1);
            return ResourceIdentifier.fromString((String)URLDecoder.decode(resourcePath, StandardCharsets.UTF_8));
        }).orElseThrow(() -> new IllegalArgumentException("HTTP request contains no URI"));
        this.eventEndpoint = EventConstants.isEventEndpoint((String)this.requestedResource.getEndpoint());
        this.requestedQos = this.determineRequestedQos(routingContext);
    }

    private QoS determineRequestedQos(RoutingContext context) {
        int qosLevel;
        String qos = context.request().getHeader("QoS-Level");
        if (Strings.isNullOrEmpty((Object)qos)) {
            if (this.isEventEndpoint()) {
                return QoS.AT_LEAST_ONCE;
            }
            return QoS.AT_MOST_ONCE;
        }
        try {
            qosLevel = Integer.parseInt(qos);
        }
        catch (NumberFormatException e) {
            return null;
        }
        switch (qosLevel) {
            case 0: {
                return QoS.AT_MOST_ONCE;
            }
            case 1: {
                return QoS.AT_LEAST_ONCE;
            }
        }
        return null;
    }

    public static HttpContext from(RoutingContext routingContext) {
        return new HttpContext(routingContext);
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public <T> T get(String key) {
        return (T)this.routingContext.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.routingContext.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public void put(String key, Object value) {
        this.routingContext.put(key, value);
    }

    public SpanContext getTracingContext() {
        return Optional.ofNullable(this.getTracingSpan()).map(Span::context).orElse(null);
    }

    public Span getTracingSpan() {
        return HttpServerSpanHelper.serverSpan((RoutingContext)this.routingContext);
    }

    @Override
    public QoS getRequestedQos() {
        return this.requestedQos;
    }

    public boolean hasValidQoS() {
        if (this.isEventEndpoint()) {
            return this.requestedQos == QoS.AT_LEAST_ONCE;
        }
        return this.requestedQos != null;
    }

    public HttpServerRequest request() {
        return this.routingContext.request();
    }

    public HttpServerResponse response() {
        return this.routingContext.response();
    }

    public void fail(Throwable throwable) {
        this.routingContext.fail(throwable);
    }

    public String getContentType() {
        String contentType = this.routingContext.parsedHeaders().contentType().value();
        return Strings.isNullOrEmpty((Object)contentType) ? null : contentType;
    }

    public boolean isEventEndpoint() {
        return this.eventEndpoint;
    }

    public ResourceIdentifier getRequestedResource() {
        return this.requestedResource;
    }

    @Override
    public Optional<Duration> getTimeToLive() {
        if (!this.isEventEndpoint()) {
            return Optional.empty();
        }
        try {
            Duration ttl = Optional.ofNullable(this.routingContext.request().getHeader("hono-ttl")).or(() -> Optional.ofNullable(this.routingContext.request().getParam("hono-ttl"))).map(Long::parseLong).map(Duration::ofSeconds).orElse(null);
            return Optional.ofNullable(ttl);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public DeviceUser getAuthenticatedDevice() {
        return Optional.ofNullable(this.routingContext.user()).filter(DeviceUser.class::isInstance).map(DeviceUser.class::cast).orElse(null);
    }

    public Integer getTimeTillDisconnect() {
        return Optional.ofNullable(this.request().getHeader("hono-ttd")).or(() -> Optional.ofNullable(this.request().getParam("hono-ttd"))).map(ttd -> {
            try {
                return Integer.parseInt(ttd);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).orElse(null);
    }

    public MetricsTags.TtdStatus getTtdStatus() {
        return Optional.ofNullable((MetricsTags.TtdStatus)this.routingContext.get(MetricsTags.TtdStatus.class.getName())).orElse(MetricsTags.TtdStatus.NONE);
    }

    @Override
    public String getOrigAddress() {
        return this.routingContext.request().uri();
    }
}

