/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.security.cert.Extension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;

public final class OCSPNonceExtension
implements Extension {
    private static final int OCSP_NONCE_SIZE = 16;
    private final byte[] value;
    private final org.bouncycastle.asn1.x509.Extension extension;

    public OCSPNonceExtension() throws IOException {
        SecureRandom random = new SecureRandom();
        byte[] nonce = new byte[16];
        random.nextBytes(nonce);
        DEROctetString derValue = new DEROctetString(nonce);
        this.value = derValue.getEncoded();
        this.extension = org.bouncycastle.asn1.x509.Extension.create((ASN1ObjectIdentifier)OCSPObjectIdentifiers.id_pkix_ocsp_nonce, (boolean)false, (ASN1Encodable)derValue);
    }

    @Override
    public String getId() {
        return OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId();
    }

    @Override
    public boolean isCritical() {
        return false;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        this.extension.encodeTo(out);
    }
}

