/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;

public interface CredentialsParser {
    default public JsonObject parseCredentialsFromClaims(JsonObject claims) {
        Objects.requireNonNull(claims);
        JsonObject credentials = new JsonObject();
        credentials.put("tenant-id", (Object)Optional.ofNullable(claims.getString("tid")).orElseThrow(() -> new ClientErrorException(401, "JWT must specify tenant ID in %s claim".formatted("tid"))));
        String authId = Optional.ofNullable(claims.getString("sub")).orElseThrow(() -> new ClientErrorException(401, "JWT must specify auth ID in %s claim".formatted("sub")));
        credentials.put("auth-id", (Object)authId);
        String issuer = Optional.ofNullable(claims.getString("iss")).orElse(authId);
        credentials.put("iss", (Object)issuer);
        return credentials;
    }

    public JsonObject parseCredentialsFromString(String var1);
}

