/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.jwt;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;

public class JwtCredentials
extends AbstractDeviceCredentials {
    private final String jws;

    private JwtCredentials(String tenantId, String authId, String jws, JsonObject clientContext) {
        super(tenantId, authId, clientContext);
        this.jws = Objects.requireNonNull(jws);
    }

    public static JwtCredentials create(String tenantId, String authId, String password) {
        return JwtCredentials.create(tenantId, authId, password, new JsonObject());
    }

    public static JwtCredentials create(String tenantId, String authId, String jws, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(authId);
        Objects.requireNonNull(jws);
        Objects.requireNonNull(clientContext);
        return new JwtCredentials(tenantId, authId, jws, clientContext);
    }

    @Override
    public String getType() {
        return "rpk";
    }

    public final String getJws() {
        return this.jws;
    }
}

