/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device.x509;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.service.auth.X509CertificateChainValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCertificateValidator
implements X509CertificateChainValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceCertificateValidator.class);

    public Future<Void> validate(List<X509Certificate> chain, TrustAnchor trustAnchor) {
        Objects.requireNonNull(chain);
        Objects.requireNonNull(trustAnchor);
        return this.validate(chain, Set.of(trustAnchor));
    }

    public Future<Void> validate(List<X509Certificate> chain, Set<TrustAnchor> trustAnchors) {
        Objects.requireNonNull(chain);
        Objects.requireNonNull(trustAnchors);
        if (chain.isEmpty()) {
            throw new IllegalArgumentException("certificate chain must not be empty");
        }
        if (trustAnchors.isEmpty()) {
            throw new IllegalArgumentException("trust anchor list must not be empty");
        }
        Promise result = Promise.promise();
        try {
            PKIXParameters params = new PKIXParameters(trustAnchors);
            params.setRevocationEnabled(false);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath path = factory.generateCertPath(chain);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(path, params);
            LOG.debug("validation of device certificate [subject DN: {}] succeeded", (Object)chain.get(0).getSubjectX500Principal().getName());
            result.complete();
        }
        catch (GeneralSecurityException e) {
            LOG.debug("validation of device certificate [subject DN: {}] failed", (Object)chain.get(0).getSubjectX500Principal().getName(), (Object)e);
            if (e instanceof CertificateException) {
                result.fail((Throwable)e);
            }
            result.fail((Throwable)new CertificateException("validation of device certificate failed", e));
        }
        return result.future();
    }
}

