/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.limiting;

import org.eclipse.hono.adapter.limiting.ConnectionLimitStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryBasedConnectionLimitStrategy
implements ConnectionLimitStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryBasedConnectionLimitStrategy.class);
    private final long memoryRequiredToStart;
    private final long memoryRequiredPerConnection;
    private final long maxMemory;

    MemoryBasedConnectionLimitStrategy(long memoryRequiredToStart, long memoryRequiredPerConnection, long memoryAvailableForLiveDataSet) {
        this.memoryRequiredToStart = memoryRequiredToStart;
        this.memoryRequiredPerConnection = memoryRequiredPerConnection;
        this.maxMemory = memoryAvailableForLiveDataSet;
    }

    public static MemoryBasedConnectionLimitStrategy forParams(long memoryRequiredToStart, long memoryRequiredPerConnection, int gcHeapPercentage) {
        if (gcHeapPercentage < 0 || gcHeapPercentage > 100) {
            throw new IllegalArgumentException("GC heap percentage must be an integer in the range [0,100]");
        }
        long memoryAvailableForLiveDataSet = Runtime.getRuntime().maxMemory() * (long)(100 - gcHeapPercentage) / 100L;
        return new MemoryBasedConnectionLimitStrategy(memoryRequiredToStart, memoryRequiredPerConnection, memoryAvailableForLiveDataSet);
    }

    @Override
    public int getRecommendedLimit() {
        long recommendedLimit = (this.maxMemory - this.memoryRequiredToStart) / this.memoryRequiredPerConnection;
        if (recommendedLimit <= 0L) {
            LOG.warn("Not enough memory. It is recommended to provide more than {} MB (currently {}).", (Object)((this.memoryRequiredToStart + this.memoryRequiredPerConnection) / 1000000L), (Object)this.getResourcesDescription());
            return 0;
        }
        if (recommendedLimit > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)recommendedLimit;
    }

    @Override
    public String getResourcesDescription() {
        return String.format("max. memory avail. for live data-set: %dMB, memory required to start: %dMB", this.maxMemory / 1000000L, this.memoryRequiredToStart / 1000000L);
    }
}

