/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import java.util.Map;
import java.util.Objects;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.command.CommandConsumerFactory;
import org.eclipse.hono.client.command.CommandResponseSender;
import org.eclipse.hono.client.registry.CredentialsClient;
import org.eclipse.hono.client.registry.TenantClient;
import org.eclipse.hono.client.telemetry.EventSender;
import org.eclipse.hono.client.telemetry.TelemetrySender;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.TelemetryExecutionContext;
import org.eclipse.hono.util.TenantObject;

public interface ProtocolAdapter {
    public String getTypeName();

    public Map<String, Object> getDownstreamMessageProperties(TelemetryExecutionContext var1);

    public TenantClient getTenantClient();

    public CredentialsClient getCredentialsClient();

    public TelemetrySender getTelemetrySender(TenantObject var1);

    public EventSender getEventSender(TenantObject var1);

    public CommandConsumerFactory getCommandConsumerFactory();

    public CommandResponseSender getCommandResponseSender(MessagingType var1, TenantObject var2);

    public Future<RegistrationAssertion> getRegistrationAssertion(String var1, String var2, Device var3, SpanContext var4);

    public Future<?> sendTtdEvent(String var1, String var2, Device var3, Integer var4, SpanContext var5);

    public Future<TenantObject> isAdapterEnabled(TenantObject var1);

    public Future<Void> checkMessageLimit(TenantObject var1, long var2, SpanContext var4);

    default public Future<Integer> getTimeUntilDisconnect(TenantObject tenant, Integer deviceTtd) {
        Objects.requireNonNull(tenant);
        if (deviceTtd == null) {
            return Future.succeededFuture();
        }
        return Future.succeededFuture((Object)Math.min(tenant.getMaxTimeUntilDisconnect(this.getTypeName()), deviceTtd));
    }
}

