/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.adapter.resourcelimits.LimitedResource;
import org.eclipse.hono.adapter.resourcelimits.LimitedResourceKey;
import org.eclipse.hono.adapter.resourcelimits.ResourceLimitChecks;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.TenantObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrometheusBasedResourceLimitChecks
implements ResourceLimitChecks {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusBasedResourceLimitChecks.class);
    private final Tracer tracer;
    private final TenantClient tenantClient;
    private final AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> connectionCountCache;
    private final AsyncLoadingCache<LimitedResourceKey, LimitedResource<Duration>> connectionDurationCache;
    private final AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> dataVolumeCache;

    public PrometheusBasedResourceLimitChecks(AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> connectionCountCache, AsyncLoadingCache<LimitedResourceKey, LimitedResource<Duration>> connectionDurationCache, AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> dataVolumeCache, TenantClient tenantClient) {
        this(connectionCountCache, connectionDurationCache, dataVolumeCache, tenantClient, (Tracer)NoopTracerFactory.create());
    }

    public PrometheusBasedResourceLimitChecks(AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> connectionCountCache, AsyncLoadingCache<LimitedResourceKey, LimitedResource<Duration>> connectionDurationCache, AsyncLoadingCache<LimitedResourceKey, LimitedResource<Long>> dataVolumeCache, TenantClient tenantClient, Tracer tracer) {
        this.connectionCountCache = Objects.requireNonNull(connectionCountCache);
        this.connectionDurationCache = Objects.requireNonNull(connectionDurationCache);
        this.dataVolumeCache = Objects.requireNonNull(dataVolumeCache);
        this.tenantClient = Objects.requireNonNull(tenantClient);
        this.tracer = Objects.requireNonNull(tracer);
    }

    @Override
    public Future<Boolean> isConnectionLimitReached(TenantObject tenant, SpanContext spanContext) {
        Objects.requireNonNull(tenant);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"verify connection limit", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), tenant.getTenantId()).start();
        Promise result = Promise.promise();
        TracingHelper.TAG_CACHE_HIT.set(span, Boolean.FALSE);
        CompletableFuture value = this.connectionCountCache.get((Object)new LimitedResourceKey(tenant.getTenantId(), (arg_0, arg_1) -> ((TenantClient)this.tenantClient).get(arg_0, arg_1)));
        if (value.isDone()) {
            try {
                LimitedResource limitedResource = (LimitedResource)value.get();
                TracingHelper.TAG_CACHE_HIT.set(span, Boolean.TRUE);
                span.log(Map.of("max-connections", (Serializable)((Object)Optional.ofNullable((Long)limitedResource.getCurrentLimit()).map(String::valueOf).orElse("N/A")), "current-connections", (Serializable)limitedResource.getCurrentValue()));
                boolean isExceeded = Optional.ofNullable((Long)limitedResource.getCurrentLimit()).map(limit -> (Long)limitedResource.getCurrentValue() >= limit).orElse(false);
                result.complete((Object)isExceeded);
            }
            catch (InterruptedException | ExecutionException e) {
                TracingHelper.logError((Span)span, (Throwable)e);
                result.complete((Object)Boolean.FALSE);
            }
        } else {
            LOG.trace("Prometheus query [tenant: {}] still running, using default value", (Object)tenant.getTenantId());
            span.log("query still running, using default value");
            result.complete((Object)Boolean.FALSE);
        }
        return result.future().onSuccess(b -> {
            span.log(Map.of("limit exceeded", b));
            span.finish();
        });
    }

    @Override
    public Future<Boolean> isMessageLimitReached(TenantObject tenant, long payloadSize, SpanContext spanContext) {
        Objects.requireNonNull(tenant);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"verify message limit", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), tenant.getTenantId()).start();
        span.log(Map.of("payload-size", payloadSize));
        Promise result = Promise.promise();
        if (payloadSize <= 0L) {
            result.complete((Object)Boolean.FALSE);
        } else {
            TracingHelper.TAG_CACHE_HIT.set(span, Boolean.valueOf(false));
            CompletableFuture value = this.dataVolumeCache.get((Object)new LimitedResourceKey(tenant.getTenantId(), (arg_0, arg_1) -> ((TenantClient)this.tenantClient).get(arg_0, arg_1)));
            if (value.isDone()) {
                try {
                    LimitedResource limitedResource = (LimitedResource)value.get();
                    TracingHelper.TAG_CACHE_HIT.set(span, Boolean.valueOf(true));
                    span.log(Map.of("current period bytes limit", (Serializable)((Object)Optional.ofNullable((Long)limitedResource.getCurrentLimit()).map(String::valueOf).orElse("N/A")), "current period bytes consumed", (Serializable)limitedResource.getCurrentValue()));
                    boolean isExceeded = Optional.ofNullable((Long)limitedResource.getCurrentLimit()).map(limit -> (Long)limitedResource.getCurrentValue() + payloadSize > limit).orElse(false);
                    result.complete((Object)isExceeded);
                }
                catch (InterruptedException | ExecutionException t) {
                    TracingHelper.logError((Span)span, (Throwable)t);
                    result.complete((Object)Boolean.FALSE);
                }
            } else {
                LOG.trace("Prometheus query [tenant: {}] still running, using default value", (Object)tenant.getTenantId());
                span.log(Map.of("message", "query still running, using default value"));
                result.complete((Object)Boolean.FALSE);
            }
        }
        return result.future().onSuccess(b -> {
            span.log(Map.of("limit exceeded", b));
            span.finish();
        });
    }

    @Override
    public Future<Boolean> isConnectionDurationLimitReached(TenantObject tenant, SpanContext spanContext) {
        Objects.requireNonNull(tenant);
        Span span = TracingHelper.buildChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"verify connection duration limit", (String)this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(TracingHelper.TAG_TENANT_ID.getKey(), tenant.getTenantId()).start();
        Promise result = Promise.promise();
        TracingHelper.TAG_CACHE_HIT.set(span, Boolean.valueOf(false));
        LimitedResourceKey key = new LimitedResourceKey(tenant.getTenantId(), (arg_0, arg_1) -> ((TenantClient)this.tenantClient).get(arg_0, arg_1));
        CompletableFuture value = this.connectionDurationCache.get((Object)key);
        if (value.isDone()) {
            try {
                LimitedResource limitedResource = (LimitedResource)value.get();
                TracingHelper.TAG_CACHE_HIT.set(span, Boolean.valueOf(true));
                span.log(Map.of("current period's connection duration limit", (Serializable)((Object)Optional.ofNullable((Duration)limitedResource.getCurrentLimit()).map(String::valueOf).orElse("N/A")), "current period's connection duration consumed", (Serializable)limitedResource.getCurrentValue()));
                boolean isExceeded = Optional.ofNullable((Duration)limitedResource.getCurrentLimit()).map(limit -> ((Duration)limitedResource.getCurrentValue()).compareTo((Duration)limit) >= 0).orElse(false);
                result.complete((Object)isExceeded);
            }
            catch (InterruptedException | ExecutionException t) {
                TracingHelper.logError((Span)span, (Throwable)t);
                result.complete((Object)Boolean.FALSE);
            }
        } else {
            LOG.trace("Prometheus query [tenant: {}] still running, using default value", (Object)tenant.getTenantId());
            span.log(Map.of("message", "query still running, using default value"));
            result.complete((Object)Boolean.FALSE);
        }
        return result.future().onSuccess(b -> {
            span.log(Map.of("limit exceeded", b));
            span.finish();
        });
    }
}

