/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.resourcelimits;

import org.eclipse.hono.config.AuthenticatingClientConfigProperties;

public class PrometheusBasedResourceLimitChecksConfig
extends AuthenticatingClientConfigProperties {
    public static final int DEFAULT_CACHE_MIN_SIZE = 20;
    public static final long DEFAULT_CACHE_MAX_SIZE = 1000L;
    public static final long DEFAULT_CACHE_TIMEOUT = 15L;
    public static final int DEFAULT_CONNECT_TIMEOUT = 1000;
    public static final long DEFAULT_QUERY_TIMEOUT = 500L;
    private int cacheMinSize = 20;
    private long cacheMaxSize = 1000L;
    private long cacheTimeout = 15L;
    private long queryTimeout = 500L;
    private int connectTimeout = 1000;

    public PrometheusBasedResourceLimitChecksConfig() {
        this.setPort(9090);
    }

    public int getCacheMinSize() {
        return this.cacheMinSize;
    }

    public void setCacheMinSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("minimum cache size must not be negative");
        }
        this.cacheMinSize = size;
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("maximum cache size must not be negative");
        }
        this.cacheMaxSize = size;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("default cache timeout must be greater than zero");
        }
        this.cacheTimeout = timeout;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(long timeout) {
        this.queryTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int timeout) {
        if (this.connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = timeout;
    }
}

