/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;

public class SubjectDnCredentials
extends AbstractDeviceCredentials {
    private SubjectDnCredentials(String tenantId, String authId, JsonObject clientContext) {
        super(tenantId, authId, clientContext);
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return SubjectDnCredentials.create(tenantId, subjectDn, new JsonObject());
    }

    public static SubjectDnCredentials create(String tenantId, String subjectDn, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(clientContext);
        return SubjectDnCredentials.create(tenantId, new X500Principal(subjectDn), clientContext);
    }

    public static SubjectDnCredentials create(String tenantId, X500Principal subjectDn) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        return SubjectDnCredentials.create(tenantId, subjectDn, new JsonObject());
    }

    public static SubjectDnCredentials create(String tenantId, X500Principal subjectDn, JsonObject clientContext) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(subjectDn);
        Objects.requireNonNull(clientContext);
        return new SubjectDnCredentials(tenantId, subjectDn.getName("RFC2253"), clientContext);
    }

    @Override
    public String getType() {
        return "x509-cert";
    }
}

