/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.adapter.auth.device.AbstractDeviceCredentials;
import org.eclipse.hono.adapter.auth.device.AuthHandler;
import org.eclipse.hono.adapter.auth.device.DeviceCredentials;
import org.eclipse.hono.adapter.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.adapter.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.util.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionContextAuthHandler<T extends ExecutionContext>
implements AuthHandler<T> {
    public static final String PROPERTY_CLIENT_IDENTIFIER = "client-id";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeviceCredentialsAuthProvider<?> authProvider;
    private final PreCredentialsValidationHandler<T> preCredentialsValidationHandler;

    protected ExecutionContextAuthHandler(DeviceCredentialsAuthProvider<?> authProvider, PreCredentialsValidationHandler<T> preCredentialsValidationHandler) {
        this.preCredentialsValidationHandler = preCredentialsValidationHandler;
        this.authProvider = authProvider;
    }

    PreCredentialsValidationHandler<T> getPreCredentialsValidationHandler() {
        return this.preCredentialsValidationHandler;
    }

    @Override
    public final Future<DeviceUser> authenticateDevice(T context) {
        Objects.requireNonNull(context);
        return this.parseCredentials(context).compose(authInfo -> {
            DeviceCredentialsAuthProvider<?> authProvider = this.getAuthProvider(context);
            if (authProvider == null) {
                return Future.failedFuture((Throwable)new IllegalStateException("no auth provider found"));
            }
            return this.authenticateDevice(context, (JsonObject)authInfo, (DeviceCredentialsAuthProvider)authProvider);
        });
    }

    private <C extends AbstractDeviceCredentials> Future<DeviceUser> authenticateDevice(T context, JsonObject authInfo, DeviceCredentialsAuthProvider<C> authProvider) {
        Object credentials = authProvider.getCredentials(authInfo);
        if (credentials == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(401, "malformed credentials"));
        }
        Future<Void> preValidationResult = this.preCredentialsValidationHandler != null ? this.preCredentialsValidationHandler.handle((DeviceCredentials)credentials, context) : Future.succeededFuture();
        Promise authResult = Promise.promise();
        preValidationResult.onComplete(ar -> {
            if (ar.failed()) {
                authResult.fail(ar.cause());
            } else {
                authProvider.authenticate(credentials, context.getTracingContext(), (Handler<AsyncResult<DeviceUser>>)authResult);
            }
        });
        return authResult.future();
    }

    @Override
    public DeviceCredentialsAuthProvider<?> getAuthProvider(T context) {
        Objects.requireNonNull(context);
        return this.authProvider;
    }
}

