/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.adapter.monitoring;

import java.util.Objects;
import org.eclipse.hono.adapter.monitoring.ConnectionEventProducerOptions;

public class ConnectionEventProducerConfig {
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final ConnectionEventProducerType DEFAULT_TYPE = ConnectionEventProducerType.logging;
    private ConnectionEventProducerType type = DEFAULT_TYPE;
    private String logLevel = "info";
    private boolean debugLogLevel = false;

    public ConnectionEventProducerConfig() {
    }

    public ConnectionEventProducerConfig(ConnectionEventProducerOptions options) {
        this.setLogLevel(options.logLevel());
        this.setProducer(options.producer());
    }

    public final void setProducer(String type) {
        Objects.requireNonNull(type);
        this.type = ConnectionEventProducerType.from(type);
    }

    public final void setProducer(ConnectionEventProducerType type) {
        this.type = Objects.requireNonNull(type);
    }

    public final ConnectionEventProducerType getType() {
        return this.type;
    }

    public final void setLogLevel(String level) {
        String levelToUse;
        Objects.requireNonNull(level);
        switch (levelToUse = level.toLowerCase()) {
            case "debug": {
                this.debugLogLevel = true;
            }
            case "info": {
                this.logLevel = levelToUse;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported log level");
            }
        }
    }

    public final String getLogLevel() {
        return this.logLevel;
    }

    public final boolean isDebugLogLevel() {
        return this.debugLogLevel;
    }

    public static enum ConnectionEventProducerType {
        none,
        logging,
        events;


        public static ConnectionEventProducerType from(String name) {
            String nameToCheck = Objects.requireNonNull(name).toLowerCase();
            for (ConnectionEventProducerType type : ConnectionEventProducerType.values()) {
                if (!type.name().equals(nameToCheck)) continue;
                return type;
            }
            return none;
        }
    }
}

