/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.deviceconnection.common.Cache;
import org.eclipse.hono.util.Futures;
import org.eclipse.hono.util.Lifecycle;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicCache<K, V>
implements Cache<K, V>,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCache.class);
    protected final Vertx vertx;
    private final BasicCacheContainer cacheManager;
    private final AtomicBoolean stopCalled = new AtomicBoolean();
    private org.infinispan.commons.api.BasicCache<K, V> cache;

    protected BasicCache(Vertx vertx, BasicCacheContainer cacheManager) {
        this.vertx = Objects.requireNonNull(vertx);
        this.cacheManager = Objects.requireNonNull(cacheManager);
    }

    protected abstract Future<Void> connectToCache();

    protected abstract boolean isStarted();

    public Future<Void> start() {
        LOG.info("starting cache");
        return this.connectToCache();
    }

    public Future<Void> stop() {
        if (!this.stopCalled.compareAndSet(false, true)) {
            return Future.succeededFuture();
        }
        LOG.info("stopping cache");
        this.setCache(null);
        Promise result = Promise.promise();
        this.vertx.executeBlocking(r -> {
            try {
                this.cacheManager.stop();
                r.complete();
            }
            catch (Exception t) {
                r.fail((Throwable)t);
            }
        }, stopAttempt -> {
            if (stopAttempt.succeeded()) {
                LOG.info("connection(s) to cache stopped successfully");
            } else {
                LOG.info("error trying to stop connection(s) to cache", stopAttempt.cause());
            }
            result.handle(stopAttempt);
        });
        return result.future();
    }

    protected void setCache(org.infinispan.commons.api.BasicCache<K, V> cache) {
        this.cache = cache;
    }

    protected org.infinispan.commons.api.BasicCache<K, V> getCache() {
        return this.cache;
    }

    protected final <T> Future<T> withCache(Function<org.infinispan.commons.api.BasicCache<K, V>, CompletionStage<T>> futureSupplier) {
        return Optional.ofNullable(this.cache).map(c -> Futures.create(() -> (CompletionStage)futureSupplier.apply((org.infinispan.commons.api.BasicCache)c))).orElseGet(BasicCache::noConnectionFailure).onComplete(this::postCacheAccess);
    }

    protected <T> void postCacheAccess(AsyncResult<T> cacheOperationResult) {
    }

    public Future<Void> put(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(aCache -> aCache.putAsync(key, value).thenApply(v -> null));
    }

    public Future<Void> put(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(lifespanUnit);
        return this.withCache(aCache -> aCache.putAsync(key, value, lifespan, lifespanUnit).thenApply(v -> null));
    }

    public Future<Void> putAll(Map<? extends K, ? extends V> data) {
        Objects.requireNonNull(data);
        return this.withCache(aCache -> aCache.putAllAsync(data));
    }

    public Future<Void> putAll(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(lifespanUnit);
        return this.withCache(aCache -> aCache.putAllAsync(data, lifespan, lifespanUnit));
    }

    public Future<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        return this.withCache(aCache -> aCache.removeAsync(key, value));
    }

    public Future<V> get(K key) {
        Objects.requireNonNull(key);
        return this.withCache(aCache -> aCache.getAsync(key));
    }

    public Future<Map<K, V>> getAll(Set<? extends K> keys) {
        Objects.requireNonNull(keys);
        return this.withCache(aCache -> aCache.getAllAsync(keys));
    }

    protected static <V> Future<V> noConnectionFailure() {
        return Future.failedFuture((Throwable)new ServerErrorException(503, "no connection to data grid"));
    }
}

