/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.deviceconnection.infinispan.client;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.hono.deviceconnection.infinispan.client.BasicCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotrodCache<K, V>
extends BasicCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(HotrodCache.class);
    private final AtomicBoolean connecting = new AtomicBoolean(false);
    private final RemoteCacheContainer cacheManager;
    private final String cacheName;

    public HotrodCache(Vertx vertx, RemoteCacheContainer cacheManager, String name, K connectionCheckKey, V connectionCheckValue) {
        super(vertx, (BasicCacheContainer)cacheManager, connectionCheckKey, connectionCheckValue);
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.cacheName = Objects.requireNonNull(name);
    }

    @Override
    protected Future<Void> connectToGrid() {
        Promise result = Promise.promise();
        if (this.connecting.compareAndSet(false, true)) {
            this.vertx.executeBlocking(r -> {
                try {
                    if (!this.cacheManager.isStarted()) {
                        LOG.debug("trying to start cache manager");
                        this.cacheManager.start();
                        LOG.info("started cache manager, now connecting to remote cache");
                    }
                    LOG.debug("trying to connect to remote cache");
                    this.setCache(this.cacheManager.getCache(this.cacheName, this.cacheManager.getConfiguration().forceReturnValues()));
                    if (this.getCache() == null) {
                        r.fail((Throwable)new IllegalStateException("remote cache [" + this.cacheName + "] does not exist"));
                    } else {
                        this.getCache().start();
                        r.complete(this.getCache());
                    }
                }
                catch (Throwable t) {
                    r.fail(t);
                }
            }, attempt -> {
                if (attempt.succeeded()) {
                    LOG.info("successfully connected to remote cache");
                    result.complete();
                } else {
                    LOG.debug("failed to connect to remote cache: {}", (Object)attempt.cause().getMessage());
                    result.fail(attempt.cause());
                }
                this.connecting.set(false);
            });
        } else {
            LOG.info("already trying to establish connection to data grid");
            result.fail("already trying to establish connection to data grid");
        }
        return result.future();
    }

    @Override
    protected boolean isStarted() {
        return this.cacheManager.isStarted() && this.getCache() != null;
    }
}

