/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.provider.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ResourceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.itemPropertyDescriptors.add(new IItemPropertyDescriptor(){

                @Override
                public void setPropertyValue(Object object, Object value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void resetPropertyValue(Object object) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean isSortChoices(Object object) {
                    return false;
                }

                @Override
                public boolean isPropertySet(Object object) {
                    return ((Resource)object).getURI() != null;
                }

                @Override
                public boolean isMultiLine(Object object) {
                    return false;
                }

                @Override
                public boolean isMany(Object object) {
                    return false;
                }

                @Override
                public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
                    return false;
                }

                @Override
                public Object getPropertyValue(Object object) {
                    return ((Resource)object).getURI();
                }

                @Override
                public IItemLabelProvider getLabelProvider(Object object) {
                    return new IItemLabelProvider(){

                        public String getText(Object object) {
                            return object.toString();
                        }

                        public Object getImage(Object object) {
                            return null;
                        }
                    };
                }

                @Override
                public String getId(Object object) {
                    return "uri";
                }

                @Override
                public Object getHelpContextIds(Object object) {
                    return null;
                }

                @Override
                public String[] getFilterFlags(Object object) {
                    return null;
                }

                @Override
                public Object getFeature(Object object) {
                    return 1;
                }

                @Override
                public String getDisplayName(Object object) {
                    return "URI";
                }

                @Override
                public String getDescription(Object object) {
                    return "The number of resources";
                }

                @Override
                public Collection<?> getChoiceOfValues(Object object) {
                    return null;
                }

                @Override
                public String getCategory(Object object) {
                    return null;
                }

                @Override
                public boolean canSetProperty(Object object) {
                    return false;
                }
            });
            this.itemPropertyDescriptors.add(new IItemPropertyDescriptor(){

                @Override
                public void setPropertyValue(Object object, Object value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void resetPropertyValue(Object object) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean isSortChoices(Object object) {
                    return false;
                }

                @Override
                public boolean isPropertySet(Object object) {
                    return true;
                }

                @Override
                public boolean isMultiLine(Object object) {
                    return false;
                }

                @Override
                public boolean isMany(Object object) {
                    return false;
                }

                @Override
                public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
                    return false;
                }

                @Override
                public Object getPropertyValue(Object object) {
                    return ((Resource)object).getTimeStamp();
                }

                @Override
                public IItemLabelProvider getLabelProvider(Object object) {
                    return new IItemLabelProvider(){

                        public String getText(Object object) {
                            return EcoreUtil.convertToString((EDataType)EcorePackage.Literals.EDATE, (Object)new Date((Long)object));
                        }

                        public Object getImage(Object object) {
                            return null;
                        }
                    };
                }

                @Override
                public String getId(Object object) {
                    return "timeStamp";
                }

                @Override
                public Object getHelpContextIds(Object object) {
                    return null;
                }

                @Override
                public String[] getFilterFlags(Object object) {
                    return null;
                }

                @Override
                public Object getFeature(Object object) {
                    return 8;
                }

                @Override
                public String getDisplayName(Object object) {
                    return "Time Stamp";
                }

                @Override
                public String getDescription(Object object) {
                    return "The version time stamp";
                }

                @Override
                public Collection<?> getChoiceOfValues(Object object) {
                    return null;
                }

                @Override
                public String getCategory(Object object) {
                    return null;
                }

                @Override
                public boolean canSetProperty(Object object) {
                    return false;
                }
            });
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public boolean hasChildren(Object object) {
        return !((Resource)object).isLoaded() || super.hasChildren(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<?> getChildren(Object object) {
        Object object2 = object;
        synchronized (object2) {
            Resource.Internal resource = (Resource.Internal)object;
            if (resource.isLoading()) {
                return Collections.singleton("Loading...");
            }
            EList contents = resource.getContents();
            ArrayList result = new ArrayList(contents.size());
            for (Object o : contents) {
                if (AdapterFactoryEditingDomain.isControlled(o)) continue;
                result.add(o);
            }
            return result;
        }
    }

    @Override
    public Object getParent(Object object) {
        return ((Resource)object).getResourceSet();
    }

    @Override
    public Object getImage(Object object) {
        Resource resource = (Resource)object;
        Object image = this.getResourceLocator().getImage("full/obj16/Resource");
        for (Object o : resource.getContents()) {
            if (!AdapterFactoryEditingDomain.isControlled(o)) continue;
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(this.getImage("full/ovr16/ControlledObjectTarget"));
            image = new ComposedImage(images);
            break;
        }
        return image;
    }

    @Override
    public String getText(Object object) {
        Resource resource = (Resource)object;
        return resource.getURI() == null ? "" : resource.getURI().toString();
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(Resource.class)) {
            case 1: {
                this.fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: {
                this.fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.emptyList();
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return EMFEditPlugin.INSTANCE;
    }

    @Override
    protected Command factorRemoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        Resource resource = (Resource)commandParameter.getOwner();
        if (!resource.getContents().containsAll(commandParameter.getCollection())) {
            return UnexecutableCommand.INSTANCE;
        }
        return new RemoveCommand(domain, resource.getContents(), commandParameter.getCollection());
    }

    @Override
    protected Command factorMoveCommand(EditingDomain domain, CommandParameter commandParameter) {
        Resource resource = (Resource)commandParameter.getOwner();
        if (!resource.getContents().contains(commandParameter.getValue())) {
            return UnexecutableCommand.INSTANCE;
        }
        return new MoveCommand(domain, resource.getContents(), commandParameter.getValue(), commandParameter.getIndex());
    }

    @Override
    protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
        Resource resource = (Resource)commandParameter.getOwner();
        return new AddCommand(domain, resource.getContents(), commandParameter.getCollection());
    }
}

