/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] bytes;
    protected int index;

    public ByteArrayOutputStream() {
        this(1024);
    }

    public ByteArrayOutputStream(int capacity) {
        this.bytes = new byte[capacity];
    }

    @Override
    public void write(int byteValue) throws IOException {
        if (this.index >= this.bytes.length) {
            byte[] newBytes = new byte[this.bytes.length * 2];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            this.bytes = newBytes;
        }
        this.bytes[this.index++] = (byte)byteValue;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.index];
        System.arraycopy(this.bytes, 0, result, 0, this.index);
        return result;
    }
}

