/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.ResourceLocator;

public abstract class DelegatingResourceLocator
implements ResourceLocator {
    protected Map<String, String> strings = new HashMap<String, String>();
    protected Map<String, String> untranslatedStrings = new HashMap<String, String>();
    protected Map<String, Object> images = new HashMap<String, Object>();
    protected boolean shouldTranslate = true;

    protected abstract ResourceLocator getPrimaryResourceLocator();

    protected abstract ResourceLocator[] getDelegateResourceLocators();

    public Object getImage(String key) {
        Object result = this.images.get(key);
        if (result == null) {
            ResourceLocator pluginResourceLocator = this.getPrimaryResourceLocator();
            if (pluginResourceLocator == null) {
                try {
                    result = this.doGetImage(key);
                }
                catch (IOException exception) {
                    result = this.delegatedGetImage(key);
                }
            } else {
                try {
                    result = pluginResourceLocator.getImage(key);
                }
                catch (MissingResourceException exception) {
                    result = this.delegatedGetImage(key);
                }
            }
            this.images.put(key, result);
        }
        return result;
    }

    protected Object doGetImage(String key) throws IOException {
        return null;
    }

    protected static String extensionFor(String key) {
        String extension;
        String result = ".gif";
        int index = key.lastIndexOf(46);
        if (index != -1 && ("png".equalsIgnoreCase(extension = key.substring(index + 1)) || "gif".equalsIgnoreCase(extension) || "bmp".equalsIgnoreCase(extension) || "ico".equalsIgnoreCase(extension) || "jpg".equalsIgnoreCase(extension) || "jpeg".equalsIgnoreCase(extension) || "tif".equalsIgnoreCase(extension) || "tiff".equalsIgnoreCase(extension))) {
            result = "";
        }
        return result;
    }

    protected Object delegatedGetImage(String key) throws MissingResourceException {
        ResourceLocator[] delegateResourceLocators = this.getDelegateResourceLocators();
        int i = 0;
        while (i < delegateResourceLocators.length) {
            try {
                return delegateResourceLocators[i].getImage(key);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_ImageResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    public String getString(String key, boolean translate) {
        Map<String, String> stringMap = translate ? this.strings : this.untranslatedStrings;
        String result = stringMap.get(key);
        if (result == null) {
            try {
                ResourceLocator pluginResourceLocator = this.getPrimaryResourceLocator();
                result = pluginResourceLocator == null ? this.doGetString(key, translate) : pluginResourceLocator.getString(key, translate);
            }
            catch (MissingResourceException exception) {
                result = this.delegatedGetString(key, translate);
            }
            stringMap.put(key, result);
        }
        return result;
    }

    protected String doGetString(String key, boolean translate) throws MissingResourceException {
        return key;
    }

    protected String delegatedGetString(String key, boolean translate) {
        ResourceLocator[] delegateResourceLocators = this.getDelegateResourceLocators();
        int i = 0;
        while (i < delegateResourceLocators.length) {
            try {
                return delegateResourceLocators[i].getString(key, translate);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException("The string resource ''" + key + "'' could not be located", this.getClass().getName(), key);
    }

    public String getString(String key, Object[] substitutions) {
        return this.getString(key, substitutions, this.shouldTranslate());
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getString(key, translate);
    }
}

