/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.eclipse.ditto.json.JsonField;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.base.entity.id.EntityId;
import org.eclipse.ditto.model.base.exceptions.SignalEnrichmentFailedException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.json.Jsonifiable;
import org.eclipse.ditto.model.things.ThingId;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedJsonifiable;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSession;
import org.eclipse.ditto.services.models.signalenrichment.SignalEnrichmentFacade;
import org.eclipse.ditto.signals.base.Signal;

@Immutable
final class SessionedSignal
implements SessionedJsonifiable {
    private final Signal<?> signal;
    private final DittoHeaders sessionHeaders;
    private final StreamingSession session;

    SessionedSignal(Signal<?> signal, DittoHeaders sessionHeaders, StreamingSession session) {
        this.signal = signal;
        this.sessionHeaders = sessionHeaders;
        this.session = session;
    }

    @Override
    public Jsonifiable.WithPredicate<JsonObject, JsonField> getJsonifiable() {
        return this.signal;
    }

    @Override
    public DittoHeaders getDittoHeaders() {
        return this.signal.getDittoHeaders();
    }

    @Override
    public CompletionStage<JsonObject> retrieveExtraFields(@Nullable SignalEnrichmentFacade facade) {
        EntityId entityId = this.signal.getEntityId();
        Optional<JsonFieldSelector> extraFields = this.session.getExtraFields();
        if (extraFields.isPresent() && (facade == null || !(entityId instanceof ThingId))) {
            CompletableFuture<JsonObject> future = new CompletableFuture<JsonObject>();
            future.completeExceptionally(SignalEnrichmentFailedException.newBuilder().dittoHeaders(this.signal.getDittoHeaders()).build());
            return future;
        }
        if (extraFields.isPresent()) {
            return facade.retrievePartialThing((ThingId)entityId, extraFields.get(), this.sessionHeaders, this.signal);
        }
        return CompletableFuture.completedFuture(JsonObject.empty());
    }

    @Override
    public Optional<StreamingSession> getSession() {
        return Optional.of(this.session);
    }
}

