/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.ActorRef;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.eclipse.ditto.json.JsonFieldSelector;
import org.eclipse.ditto.json.JsonObject;
import org.eclipse.ditto.model.query.criteria.Criteria;
import org.eclipse.ditto.model.query.things.ThingPredicateVisitor;
import org.eclipse.ditto.model.things.Thing;
import org.eclipse.ditto.signals.base.Signal;
import org.eclipse.ditto.signals.events.things.ThingEventToThingConverter;

public final class StreamingSession {
    private final List<String> namespaces;
    private final Predicate<Thing> thingPredicate;
    @Nullable
    private final JsonFieldSelector extraFields;
    private final ActorRef streamingSessionActor;

    private StreamingSession(List<String> namespaces, @Nullable Criteria eventFilterCriteria, @Nullable JsonFieldSelector extraFields, ActorRef streamingSessionActor) {
        this.namespaces = namespaces;
        this.thingPredicate = eventFilterCriteria == null ? thing -> true : ThingPredicateVisitor.apply((Criteria)eventFilterCriteria);
        this.extraFields = extraFields;
        this.streamingSessionActor = streamingSessionActor;
    }

    static StreamingSession of(List<String> namespaces, @Nullable Criteria eventFilterCriteria, @Nullable JsonFieldSelector extraFields, ActorRef streamingSessionActor) {
        return new StreamingSession(namespaces, eventFilterCriteria, extraFields, streamingSessionActor);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public Optional<JsonFieldSelector> getExtraFields() {
        return Optional.ofNullable(this.extraFields);
    }

    public Thing mergeThingWithExtra(Signal<?> signal, JsonObject extra) {
        return ThingEventToThingConverter.mergeThingWithExtraFields(signal, (JsonFieldSelector)this.extraFields, (JsonObject)extra).orElseGet(() -> Thing.newBuilder().build());
    }

    public boolean matchesFilter(Thing thing) {
        return this.thingPredicate.test(thing);
    }

    public ActorRef getStreamingSessionActor() {
        return this.streamingSessionActor;
    }
}

