/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming;

import akka.stream.javadsl.SourceQueueWithComplete;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.eclipse.ditto.model.base.acks.AcknowledgementLabel;
import org.eclipse.ditto.model.base.common.ConditionChecker;
import org.eclipse.ditto.model.base.json.JsonSchemaVersion;
import org.eclipse.ditto.services.gateway.streaming.actors.SessionedJsonifiable;

public final class Connect {
    private final SourceQueueWithComplete<SessionedJsonifiable> eventAndResponsePublisher;
    private final String connectionCorrelationId;
    private final String type;
    private final JsonSchemaVersion jsonSchemaVersion;
    @Nullable
    private final Instant sessionExpirationTime;
    private final Set<AcknowledgementLabel> declaredAcknowledgementLabels;

    public Connect(SourceQueueWithComplete<SessionedJsonifiable> eventAndResponsePublisher, CharSequence connectionCorrelationId, String type, JsonSchemaVersion jsonSchemaVersion, @Nullable Instant sessionExpirationTime, Set<AcknowledgementLabel> declaredAcknowledgementLabels) {
        this.eventAndResponsePublisher = eventAndResponsePublisher;
        this.connectionCorrelationId = ((CharSequence)ConditionChecker.checkNotNull((Object)connectionCorrelationId, (String)"connectionCorrelationId")).toString();
        this.type = type;
        this.jsonSchemaVersion = jsonSchemaVersion;
        this.sessionExpirationTime = sessionExpirationTime;
        this.declaredAcknowledgementLabels = declaredAcknowledgementLabels;
    }

    public SourceQueueWithComplete<SessionedJsonifiable> getEventAndResponsePublisher() {
        return this.eventAndResponsePublisher;
    }

    public String getConnectionCorrelationId() {
        return this.connectionCorrelationId;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Instant> getSessionExpirationTime() {
        return Optional.ofNullable(this.sessionExpirationTime);
    }

    public JsonSchemaVersion getJsonSchemaVersion() {
        return this.jsonSchemaVersion;
    }

    public Set<AcknowledgementLabel> getDeclaredAcknowledgementLabels() {
        return this.declaredAcknowledgementLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connect connect = (Connect)o;
        return Objects.equals(this.eventAndResponsePublisher, connect.eventAndResponsePublisher) && Objects.equals(this.connectionCorrelationId, connect.connectionCorrelationId) && Objects.equals(this.type, connect.type) && Objects.equals(this.sessionExpirationTime, connect.sessionExpirationTime) && Objects.equals(this.declaredAcknowledgementLabels, connect.declaredAcknowledgementLabels);
    }

    public int hashCode() {
        return Objects.hash(this.eventAndResponsePublisher, this.connectionCorrelationId, this.type, this.sessionExpirationTime, this.declaredAcknowledgementLabels);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [eventAndResponsePublisher=" + this.eventAndResponsePublisher + ", connectionCorrelationId=" + this.connectionCorrelationId + ", type=" + this.type + ", sessionExpirationTime=" + this.sessionExpirationTime + ", declaredAcknowledgementLabels" + this.declaredAcknowledgementLabels + "]";
    }
}

