/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.services.gateway.streaming.actors;

import akka.actor.AbstractActor;
import akka.actor.AbstractActorWithTimers;
import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.OneForOneStrategy;
import akka.actor.Props;
import akka.actor.SupervisorStrategy;
import akka.japi.pf.DeciderBuilder;
import akka.japi.pf.ReceiveBuilder;
import akka.stream.ActorMaterializer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.stream.StreamSupport;
import org.eclipse.ditto.protocoladapter.HeaderTranslator;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthenticationFactory;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtAuthenticationResultProvider;
import org.eclipse.ditto.services.gateway.security.authentication.jwt.JwtValidator;
import org.eclipse.ditto.services.gateway.streaming.Connect;
import org.eclipse.ditto.services.gateway.streaming.actors.StreamingSessionActor;
import org.eclipse.ditto.services.gateway.util.config.streaming.DefaultStreamingConfig;
import org.eclipse.ditto.services.gateway.util.config.streaming.StreamingConfig;
import org.eclipse.ditto.services.models.concierge.pubsub.DittoProtocolSub;
import org.eclipse.ditto.services.utils.akka.actors.ModifyConfigBehavior;
import org.eclipse.ditto.services.utils.akka.actors.RetrieveConfigBehavior;
import org.eclipse.ditto.services.utils.akka.logging.DittoDiagnosticLoggingAdapter;
import org.eclipse.ditto.services.utils.akka.logging.DittoLoggerFactory;
import org.eclipse.ditto.services.utils.metrics.DittoMetrics;
import org.eclipse.ditto.services.utils.metrics.instruments.gauge.Gauge;
import org.eclipse.ditto.services.utils.search.SubscriptionManager;

public final class StreamingActor
extends AbstractActorWithTimers
implements RetrieveConfigBehavior,
ModifyConfigBehavior {
    public static final String ACTOR_NAME = "streaming";
    private final DittoProtocolSub dittoProtocolSub;
    private final ActorRef commandRouter;
    private final Gauge streamingSessionsCounter;
    private final JwtValidator jwtValidator;
    private final JwtAuthenticationResultProvider jwtAuthenticationResultProvider;
    private final Props subscriptionManagerProps;
    private final DittoDiagnosticLoggingAdapter logger = DittoLoggerFactory.getDiagnosticLoggingAdapter((Actor)this);
    private final HeaderTranslator headerTranslator;
    private int childCounter = -1;
    private StreamingConfig streamingConfig;
    private final SupervisorStrategy strategy = new OneForOneStrategy(true, DeciderBuilder.match(Throwable.class, e -> {
        this.logger.error(e, "Escalating above actor!");
        return SupervisorStrategy.escalate();
    }).matchAny(e -> {
        this.logger.error("Unknown message:'{}'! Escalating above actor!", e);
        return SupervisorStrategy.escalate();
    }).build());

    private StreamingActor(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig, HeaderTranslator headerTranslator, ActorRef pubSubMediator, ActorRef conciergeForwarder) {
        this.dittoProtocolSub = dittoProtocolSub;
        this.commandRouter = commandRouter;
        this.streamingConfig = streamingConfig;
        this.headerTranslator = headerTranslator;
        this.streamingSessionsCounter = DittoMetrics.gauge((String)"streaming_sessions_count");
        this.jwtValidator = jwtAuthenticationFactory.getJwtValidator();
        this.jwtAuthenticationResultProvider = jwtAuthenticationFactory.newJwtAuthenticationResultProvider();
        this.subscriptionManagerProps = SubscriptionManager.props((Duration)streamingConfig.getSearchIdleTimeout(), (ActorRef)pubSubMediator, (ActorRef)conciergeForwarder, (ActorMaterializer)ActorMaterializer.create((ActorRefFactory)this.getContext()));
        this.scheduleScrapeStreamSessionsCounter();
    }

    public static Props props(DittoProtocolSub dittoProtocolSub, ActorRef commandRouter, JwtAuthenticationFactory jwtAuthenticationFactory, StreamingConfig streamingConfig, HeaderTranslator headerTranslator, ActorRef pubSubMediator, ActorRef conciergeForwarder) {
        return Props.create(StreamingActor.class, (Object[])new Object[]{dittoProtocolSub, commandRouter, jwtAuthenticationFactory, streamingConfig, headerTranslator, pubSubMediator, conciergeForwarder});
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.strategy;
    }

    public AbstractActor.Receive createReceive() {
        return this.retrieveConfigBehavior().orElse(this.modifyConfigBehavior()).orElse(this.createConnectAndMetricsBehavior()).orElse(ReceiveBuilder.create().matchAny(any -> this.logger.warning("Got unknown message: '{}'", any)).build());
    }

    private AbstractActor.Receive createConnectAndMetricsBehavior() {
        return ReceiveBuilder.create().match(Connect.class, connect -> {
            ActorRef eventAndResponsePublisher = connect.getEventAndResponsePublisher();
            eventAndResponsePublisher.forward(connect, (ActorContext)this.getContext());
            String sessionActorName = this.getUniqueChildActorName(connect.getConnectionCorrelationId());
            ActorRef streamingSessionActor = this.getContext().actorOf(StreamingSessionActor.props(connect, this.dittoProtocolSub, this.commandRouter, this.streamingConfig.getAcknowledgementConfig(), this.headerTranslator, this.subscriptionManagerProps, this.jwtValidator, this.jwtAuthenticationResultProvider), sessionActorName);
            this.getSender().tell((Object)streamingSessionActor, ActorRef.noSender());
        }).matchEquals((Object)Control.RETRIEVE_WEBSOCKET_CONFIG, this::replyWebSocketConfig).matchEquals((Object)Control.SCRAPE_STREAM_COUNTER, this::updateStreamingSessionsCounter).build();
    }

    public Config getConfig() {
        return this.streamingConfig.render().getConfig(ACTOR_NAME);
    }

    public Config setConfig(Config config) {
        this.streamingConfig = DefaultStreamingConfig.of((Config)config.atKey(ACTOR_NAME).withFallback((ConfigMergeable)this.streamingConfig.render()));
        this.scheduleScrapeStreamSessionsCounter();
        return this.streamingConfig.render();
    }

    private String getUniqueChildActorName(String suffix) {
        int counter = ++this.childCounter;
        return String.format("%x-%s", counter, URLEncoder.encode(suffix, StandardCharsets.UTF_8));
    }

    private void scheduleScrapeStreamSessionsCounter() {
        this.getTimers().startPeriodicTimer((Object)Control.SCRAPE_STREAM_COUNTER, (Object)Control.SCRAPE_STREAM_COUNTER, this.streamingConfig.getSessionCounterScrapeInterval());
    }

    private void replyWebSocketConfig(Control trigger) {
        this.getSender().tell((Object)this.streamingConfig.getWebsocketConfig(), this.getSelf());
    }

    private void updateStreamingSessionsCounter(Control trigger) {
        if (this.getContext() != null) {
            this.streamingSessionsCounter.set(Long.valueOf(StreamSupport.stream(this.getContext().getChildren().spliterator(), false).count()));
        }
    }

    public static enum Control {
        SCRAPE_STREAM_COUNTER,
        RETRIEVE_WEBSOCKET_CONFIG;

    }
}

